# Нанороботы

![Нанороботы, Карл.](oredict:oc:nanomachines)

Это миниатюрные устройства, которые интегрируются с вашей нервной системой, делая вас сильнее, лучше и быстрее или убьют вас. Иногда сразу! Проще говоря, нанороботы обеспечивают управляемую систему питания наделяющую игрока положительнымы (и отрицательнымы) способностями. Для "установки" нанороботов, съешьте их!

Однажды попав в организм, нанороботы добавляют новый индикатор энергии, который показывает, сколько энергии ваши нанороботы имеют. Вы можете перезарядить их, стоя у [зарядного устройства](../block/charger.md). Чем больше вы используете нанороботов, тем больше энергии они потребляют.

Нанороботы обеспечивают некоторое количество "контактов", которые могут быть активированы, накладывая на игрока различные эффекты, начиная с визуальных эффектов, таких как частицы, появляющиеся рядом с игроком и заканчивая эффектами от зелий, и некоторыми более редкими и особыми вещами!

Какой эффект получится при активации контакта зависит от текущей конфигурации нанороботов, связь между контактом и эффектом случайно для каждой конфигурации. Это означает, что потребуется активировать различные контакты, чтобы увидеть, что они делают. Если вам не повезло с конфигурацией, вы всегда можете переконфигурировать ваших нанороботов, добавив новых (просто съешьте еще). Если, вы хотите избавиться от них, выпейте [кислоту](acid.md), она выведет нанороботов из организма. Помните, большое количество активных контактов одновременно вредно для вашего организма!

По умолчанию, нанороботы находятся в режиме ожидания. Вы можете контролировать их с помощью беспроводных сообщений, [планшет](tablet.md) с [беспроводной сетевой картой](wlanCard.md) строго рекомендуется. Нанороботы реагирует только на беспроводные сигналы, источник которых находится не дальше двух метров, но они реагируют на все сообщения на любом порту и с любых устройств!

Нанороботы работают по простому проепритарному протоколу: каждый пакет может состоять из множества частей, первый это "заголовок" и он должен быть строкой с текстом `nanomachines`. Вторая часть должна быть командой. Дополнительные части это параметры для команды. Доступны следующие команды, форматированы как `имякоманды(аргумент1, ...)`:

- `setResponsePort(port:number)` - Устанавливает порт, на который будут отправляться ответные сообщения от нанороботов, для команд, требующих ответа.
- `getPowerState()` - Запрос текущего и максимального количества энергии нанороботов.
- `getHealth()` - Запрос состояния здоровья игрока.
- `getHunger()` - Запрос уровня голода игрока.
- `getAge()` - Запрос возраста игрока (в секундах).
- `getName()` - Запрос имени игрока.
- `getExperience()` - Запрос уровня опыта игрока.
- `getTotalInputCount()` - Запрос общего количества доступных контактов.
- `getSafeActiveInputs()` - Запрос количества *безопасных* активных контактов.
- `getMaxActiveInputs()` - Запрос *максимального* количества активных контактов.
- `getInput(index:number)` - Запрос текущего состояния контакта с указанным индексом.
- `setInput(index:number, value:boolean)` - Устанавливает указанный контакт в указанное состояние.
- `getActiveEffects()` - Запрос списка активных эффектов. Некоторые эффекты могут быть не показаны в этом списке.
- `saveConfiguration()` - Требует наличия в инвентаре нанороботов, сохраняет текущую конфигурацию нанороботов игрока в них.

Например, в OpenOS:
- `component.modem.broadcast(1, "nanomachines", "setInput", 1, true)` активирует первый контакт.
- `component.modem.broadcast(1, "nanomachines", "getHealth")` запрос информации о состоянии здоровья игрока.