/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator.handler;

import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigurationHandler {
    private static boolean initialized;
    public static ConfigFile config;
    public static boolean clientCheckUpdates;
    public static boolean disableCraftingGrid;
    public static ItemStack nugget;

    public static void init(File file) {
        if (!initialized) {
            config = new ConfigFile(file).setComment("Translocator Configuration File\nDeleting any element will restore it to it's default value");
            initialized = true;
        }
    }

    public static void loadConfig() {
        int meta;
        Item item;
        clientCheckUpdates = config.getTag("clientUpdateCheck").getBooleanValue(true);
        disableCraftingGrid = config.getTag("disableCraftingGrid").setComment("Setting this to true will disable the placement of the CraftingGrid.").getBooleanValue(false);
        ConfigTag tag = config.getTag("nuggetReplacement").setComment("The name of the item used to set the Translocator to filter mode. Diamond Nugget by default. Format <modid>:<registeredItemName>|<meta>, Meta can be replaced with \"WILD\"");
        String name = tag.getValue("translocator:diamondNugget|0");
        try {
            int pipeIndex = name.lastIndexOf("|");
            item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name.substring(0, pipeIndex)));
            if (item == null) {
                throw new Exception("Item does not exist!");
            }
            String metaString = name.substring(pipeIndex + 1);
            meta = metaString.equalsIgnoreCase("WILD") ? Short.MAX_VALUE : Integer.parseInt(metaString);
        }
        catch (Exception e) {
            tag.setValue("translocator:diamondNugget|0");
            FMLLog.log((String)"Translocators", (Level)Level.ERROR, (Throwable)e, (String)"Failed to parse Nugget Replacement config entry, It has been reset to default.", (Object[])new Object[0]);
            item = Items.field_151045_i;
            meta = 0;
        }
        nugget = new ItemStack(item, 1, meta);
    }
}

