/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.tileentity;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntity;

public class TileUncolossalChest
extends InventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    private static final int TICK_MODULUS = 200;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private String customName = null;
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private Block block = UncolossalChest.getInstance();

    public TileUncolossalChest() {
        super(5, "uncolossalChest", 64);
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_174877_v().func_177971_a(new Vec3i((double)(-range), (double)(-range), (double)(-range))), this.func_174877_v().func_177971_a(new Vec3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.25f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 1.15f, false);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 1.15f, false);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
        super.func_174889_b(entityPlayer);
        this.triggerPlayerUsageChange(1);
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
        super.func_174886_c(entityPlayer);
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        ContiguousSet integers = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.func_70302_i_())), (DiscreteDomain)DiscreteDomain.integers());
        return ArrayUtils.toPrimitive((Integer[])((Integer[])integers.toArray((Object[])new Integer[integers.size()])));
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : L10NHelpers.localize((String)"general.colossalchests.uncolossalchest.name");
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public EnumFacing getRotation() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != UncolossalChest.getInstance()) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)blockState, (IProperty)UncolossalChest.FACING, (Object)EnumFacing.NORTH);
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

