/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.cmd;

import info.ata4.minecraft.dragon.client.gui.GuiDragonDebug;
import info.ata4.minecraft.dragon.server.cmd.CommandBaseNested;
import info.ata4.minecraft.dragon.server.cmd.CommandDragonLambda;
import info.ata4.minecraft.dragon.server.cmd.IDragonModifier;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.EnumDragonLifeStage;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class CommandDragonDebug
extends CommandBaseNested
implements IDragonModifier {
    public CommandDragonDebug() {
        this.addCommand(new CommandDragonLambda("toItem", dragon -> dragon.getLifeStageHelper().transformToEgg()));
        this.addCommand(new CommandDragonLambda("dumpNBT", dragon -> {
            File dumpFile = new File(Minecraft.func_71410_x().field_71412_D, String.format("dragon_%08x.nbt", dragon.func_145782_y()));
            try {
                NBTTagCompound nbt = dragon.serializeNBT();
                CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)dumpFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }));
        this.addCommand(new CommandDragonLambda("toggleOverlay", (server, sender, args) -> {
            GuiDragonDebug.enabled = !GuiDragonDebug.enabled;
        }));
        this.addCommand(new CommandDragonLambda("testBreeds", dragon -> new Thread(() -> {
            try {
                for (EnumDragonBreed breed : EnumDragonBreed.values()) {
                    dragon.setBreedType(breed);
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start()));
        this.addCommand(new CommandDragonLambda("testStages", dragon -> new Thread(() -> {
            try {
                for (EnumDragonLifeStage stage : EnumDragonLifeStage.values()) {
                    dragon.getLifeStageHelper().setLifeStage(stage);
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start()));
        this.addCommand(new CommandDragonLambda("testAge", dragon -> dragon.getLifeStageHelper().setTicksSinceCreation(18000)));
        this.addCommand(new CommandDragonLambda("testMount", (server, sender, args) -> this.applyModifier(server, sender, dragon -> {
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            dragon.tamedFor((EntityPlayer)player, true);
            dragon.setSaddled(true);
            dragon.func_96094_a("Puff");
            player.func_184220_m((Entity)dragon);
        })));
        this.addCommand(new CommandDragonLambda("kill", dragon -> dragon.func_70606_j(0.0f)));
    }

    public String func_71517_b() {
        return "debug";
    }
}

