/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;

public class PacketMultipartSync
extends PacketMultipart {
    public NBTTagCompound tag;
    public NBTHelper.SyncType type;

    public PacketMultipartSync() {
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, UUID partUUID) {
        super(partUUID, pos);
        this.tag = tag;
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, NBTHelper.SyncType type, UUID partUUID) {
        super(partUUID, pos);
        this.tag = tag;
        this.type = type;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.type = NBTHelper.SyncType.values()[buf.readByte()];
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.type == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeByte(this.type.ordinal());
        }
    }

    public static class Handler
    extends PacketMultipartHandler<PacketMultipartSync> {
        @Override
        public IMessage processMessage(final PacketMultipartSync message, IMultipartContainer target, final IMultipart part, MessageContext ctx) {
            if (part.getWorld().field_72995_K) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (part != null && part instanceof INBTSyncable) {
                            INBTSyncable sync = (INBTSyncable)part;
                            sync.readData(message.tag, message.type != null ? message.type : NBTHelper.SyncType.DEFAULT_SYNC);
                        }
                        part.getWorld().func_175726_f(part.getPos()).func_76630_e();
                    }
                });
            }
            return null;
        }
    }
}

