/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.core.recipes.DefinedRecipeHelper;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeItemStack;
import sonar.core.recipes.RecipeOreStack;
import sonar.core.recipes.ValueHelperV2;

public class SonarAddRecipeV2<T extends RecipeHelperV2>
implements IUndoableAction {
    public ArrayList<ISonarRecipeObject> inputs;
    public ArrayList<ISonarRecipeObject> outputs;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;
    public BiFunction<ISonarRecipe, RecipeHelperV2<ISonarRecipe>, Object> createRecipe;

    public SonarAddRecipeV2(T helper, ArrayList inputs, ArrayList<ItemStack> outputs, BiFunction<ISonarRecipe, RecipeHelperV2<ISonarRecipe>, Object> createRecipe) {
        this.helper = helper;
        this.createRecipe = createRecipe;
        if (helper instanceof DefinedRecipeHelper && (inputs.size() != ((DefinedRecipeHelper)helper).getInputSize() || outputs.size() != ((DefinedRecipeHelper)helper).getOutputSize())) {
            MineTweakerAPI.logError((String)("A " + ((RecipeHelperV2)helper).getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<ISonarRecipeObject> adaptedInputs = new ArrayList<ISonarRecipeObject>();
        ArrayList<RecipeItemStack> adaptedOutputs = new ArrayList<RecipeItemStack>();
        for (Object input : inputs) {
            if (input == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeHelperV2)helper).getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (input instanceof IItemStack) {
                adaptedInputs.add(((RecipeHelperV2)helper).buildRecipeObject(MineTweakerMC.getItemStack((IItemStack)((IItemStack)input))));
                continue;
            }
            if (input instanceof IOreDictEntry) {
                adaptedInputs.add(new RecipeOreStack(((IOreDictEntry)input).getName(), 1));
                continue;
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", ((RecipeHelperV2)helper).getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(input instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeHelperV2)helper).getRecipeID(), input));
                continue;
            }
            adaptedInputs.add(((RecipeHelperV2)helper).buildRecipeObject(input));
        }
        for (ItemStack stack : outputs) {
            adaptedOutputs.add(new RecipeItemStack(stack, false));
        }
        this.inputs = adaptedInputs;
        this.outputs = adaptedOutputs;
    }

    public void apply() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            boolean isShapeless = this.helper instanceof DefinedRecipeHelper ? ((DefinedRecipeHelper)this.helper).shapeless : true;
            Object recipe = ((RecipeHelperV2)this.helper).buildRecipe((ArrayList)this.inputs.clone(), (ArrayList)this.outputs.clone(), Lists.newArrayList(), isShapeless);
            ((RecipeHelperV2)this.helper).addRecipe(recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(this.createRecipe.apply((ISonarRecipe)recipe, (RecipeHelperV2<ISonarRecipe>)this.helper));
        } else {
            SonarCore.logger.error(String.format("Failed to add %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), this.inputs, this.outputs));
        }
    }

    public void undo() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            List values = RecipeHelperV2.getValuesFromList(this.inputs);
            Object recipe = ((RecipeHelperV2)this.helper).getRecipeFromInputs(null, values.toArray());
            if (recipe == null) {
                MineTweakerAPI.logError((String)String.format("%s: Adding Recipe - Couldn't find matching recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), values));
                return;
            }
            boolean removed = ((RecipeHelperV2)this.helper).removeRecipe(recipe);
            if (!removed) {
                MineTweakerAPI.logError((String)String.format("%s: Adding Recipe - Failed to remove recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), values));
            } else {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(this.createRecipe.apply((ISonarRecipe)recipe, (RecipeHelperV2<ISonarRecipe>)this.helper));
            }
        } else {
            SonarCore.logger.error(String.format("Adding Recipe - Failed to remove %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), this.inputs, this.outputs));
        }
    }

    public String describe() {
        Object[] objectArray = new Object[3];
        objectArray[0] = ((RecipeHelperV2)this.helper).getRecipeID();
        objectArray[1] = RecipeHelperV2.getValuesFromList(this.inputs);
        objectArray[2] = RecipeHelperV2.getValuesFromList(this.outputs);
        return String.format("Adding %s recipe (%s = %s)", objectArray);
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public boolean canUndo() {
        return true;
    }

    public Object getOverrideKey() {
        return null;
    }

    public static class Value
    extends SonarAddRecipeV2<ValueHelperV2> {
        public int recipeValue = 0;

        public Value(ValueHelperV2 helper, ArrayList inputs, ArrayList outputs, int recipeValue, BiFunction<ISonarRecipe, RecipeHelperV2<ISonarRecipe>, Object> createrecipe) {
            super(helper, inputs, outputs, createrecipe);
            this.recipeValue = recipeValue;
        }

        @Override
        public void apply() {
            if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
                ((ValueHelperV2)this.helper).addRecipe(((ValueHelperV2)this.helper).buildRecipe((ArrayList)this.inputs.clone(), (ArrayList)this.outputs.clone(), (List)Lists.newArrayList((Object[])new Integer[]{this.recipeValue}), ((ValueHelperV2)this.helper).shapeless));
            } else {
                SonarCore.logger.error(String.format("Failed to add %s recipe (%s = %s)", ((ValueHelperV2)this.helper).getRecipeID(), this.inputs, this.outputs));
            }
        }
    }
}

