/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import sonar.core.api.energy.EnergyType;
import sonar.core.utils.CustomColour;

public class FontHelper {
    public static int text(String info, int x, int y, CustomColour colour) {
        return FontHelper.text(info, x, y, colour.getRGB());
    }

    public static int text(String info, int x, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                return render.func_78276_b(info, x, y, 0x404040);
            }
            case 1: {
                return render.func_78276_b(info, x, y, 1);
            }
            case 2: {
                return render.func_78276_b(info, x, y, -1);
            }
        }
        return render.func_78276_b(info, x, y, colour);
    }

    public static int text(List<String> info, int gap, int x, int y, int colour) {
        return FontHelper.text(info, gap, 0, info.size(), x, y, colour);
    }

    public static int text(List<String> info, int start, int stop, int gap, int x, int y, int colour) {
        int textPos = 0;
        for (int i = start; i < Math.min(stop, info.size()); ++i) {
            String s = info.get(i);
            textPos += FontHelper.text(s, x, y + i * gap, colour);
        }
        return textPos;
    }

    public static int textCentre(String info, int xSize, int y, CustomColour colour) {
        return FontHelper.textCentre(info, xSize, y, colour.getRGB());
    }

    public static int textCentre(String info, int xSize, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                return render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, 0x404040);
            }
            case 1: {
                return render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, 1);
            }
            case 2: {
                return render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, -1);
            }
        }
        return render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, colour);
    }

    public static int width(String info) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        return render.func_78256_a(info);
    }

    public static int textOffsetCentre(String info, int xCentre, int y, CustomColour colour) {
        return FontHelper.textOffsetCentre(info, xCentre, y, colour.getRGB());
    }

    public static int textOffsetCentre(String info, int xCentre, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                return render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, 0x404040);
            }
            case 1: {
                return render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, 1);
            }
            case 2: {
                return render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, -1);
            }
        }
        return render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, colour);
    }

    public static void sendMessage(String string, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(string, new Object[0]));
        }
    }

    public static void sendMessage(ITextComponent component, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.func_146105_b(component);
        }
    }

    public static String formatStorage(long power) {
        return FontHelper.formatStorage(EnergyType.RF, power);
    }

    public static String formatStorage(EnergyType type, long power) {
        if (power < 1000L) {
            return power + " " + type.getStorageSuffix();
        }
        if (power < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000.0f)) + " K" + type.getStorageSuffix();
        }
        if (power < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000000.0f)) + " M" + type.getStorageSuffix();
        }
        return FontHelper.roundValue(2, Float.valueOf((float)power / 1.0E9f)) + " B" + type.getStorageSuffix();
    }

    public static String formatOutput(long power) {
        return FontHelper.formatOutput(EnergyType.RF, power);
    }

    public static String formatOutput(EnergyType type, long power) {
        if (power < 1000L) {
            return power + " " + type.getUsageSuffix();
        }
        if (power < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000.0f)) + " K" + type.getUsageSuffix();
        }
        if (power < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000000.0f)) + " M" + type.getUsageSuffix();
        }
        return FontHelper.roundValue(2, Float.valueOf((float)power / 1.0E9f)) + " B" + type.getUsageSuffix();
    }

    public static String formatStackSize(long stackSize) {
        if (stackSize < 10000L) {
            return " " + stackSize;
        }
        if (stackSize < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)stackSize / 1000.0f)) + " K";
        }
        if (stackSize < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)stackSize / 1000000.0f)) + " M";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)stackSize / 1.0E9f)) + " B";
    }

    public static String formatFluidSize(long fluidSize) {
        if (fluidSize < 10000L) {
            return " " + fluidSize + " mB";
        }
        if (fluidSize < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)fluidSize / 1000.0f)) + " KmB";
        }
        if (fluidSize < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)fluidSize / 1000000.0f)) + " MmB";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)fluidSize / 1.0E9f)) + " BmB";
    }

    public static Float roundValue(int decimalPlace, Float d) {
        BigDecimal bd = new BigDecimal(Float.toString(d.floatValue()));
        bd = bd.setScale(decimalPlace, 4);
        return Float.valueOf(bd.floatValue());
    }

    public static boolean addDigitsToString(GuiTextField box, char c, int i) {
        switch (c) {
            case '\u0001': {
                return box.func_146201_a(c, i);
            }
            case '\u0003': {
                return box.func_146201_a(c, i);
            }
            case '\u0016': {
                return false;
            }
            case '\u0018': {
                return box.func_146201_a(c, i);
            }
        }
        switch (i) {
            case 14: {
                return box.func_146201_a(c, i);
            }
            case 199: {
                return box.func_146201_a(c, i);
            }
            case 203: {
                return box.func_146201_a(c, i);
            }
            case 205: {
                return box.func_146201_a(c, i);
            }
            case 207: {
                return box.func_146201_a(c, i);
            }
            case 211: {
                return box.func_146201_a(c, i);
            }
        }
        if (Character.isDigit(c)) {
            return box.func_146201_a(c, i);
        }
        return false;
    }

    public static String translate(String string) {
        return new TextComponentTranslation(string, new Object[0]).func_150254_d();
    }

    public static int getIntFromColor(int red, int green, int blue) {
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }

    public static String getStringListToText(List<String> strings) {
        String list = "";
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            list = i != 0 ? list + ", " + string : string;
        }
        return list;
    }

    public static ArrayList<String> breakUpStringIntoLines(String multiline, int charLimit) {
        int start;
        ArrayList lines = Lists.newArrayList();
        String s = multiline;
        char[] chars = s.toCharArray();
        boolean endOfString = false;
        int end = start = 0;
        while (start < chars.length - 1) {
            int charCount = 0;
            int lastSpace = 0;
            while (charCount < charLimit) {
                if (chars[charCount + start] == ' ') {
                    lastSpace = charCount;
                }
                if (++charCount + start != s.length()) continue;
                endOfString = true;
                break;
            }
            end = endOfString ? s.length() : (lastSpace > 0 ? lastSpace + start : charCount + start);
            lines.add(s.substring(start, end));
            start = end + 1;
        }
        return lines;
    }

    public static ArrayList<String> breakLines(ArrayList<String> lines, String str, int wrapWidth) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        int i = FontHelper.sizeStringToWidth(render, str, wrapWidth);
        if (str.length() <= i) {
            lines.add(str);
            return lines;
        }
        String s = str.substring(0, i);
        char c0 = str.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = FontRenderer.func_78282_e((String)s) + str.substring(i + (flag ? 1 : 0));
        lines.add(s);
        return FontHelper.breakLines(lines, s1, wrapWidth);
    }

    public static int sizeStringToWidth(FontRenderer render, String str, int wrapWidth) {
        int k;
        int i = str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\u00a3': {
                    break;
                }
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += render.func_78263_a(c0);
                    if (!flag) break;
                    ++j;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !FontHelper.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > wrapWidth) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    public static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }
}

