/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import sonar.core.SonarCore;
import sonar.core.api.StorageSize;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.utils.ActionType;
import sonar.core.api.wrappers.FluidWrapper;

public class FluidHelper
extends FluidWrapper {
    @Override
    public void addFluidToList(List<StoredFluidStack> list, StoredFluidStack stack) {
        int pos = 0;
        for (StoredFluidStack storedTank : list) {
            if (storedTank.equalStack(stack.fluid)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(stack);
    }

    @Override
    public StoredFluidStack getStackToAdd(long inputSize, StoredFluidStack stack, StoredFluidStack returned) {
        StoredFluidStack simulateStack = null;
        simulateStack = returned == null || returned.stored == 0L ? new StoredFluidStack(stack.getFullStack(), inputSize, stack.capacity) : new StoredFluidStack(stack.getFullStack(), inputSize - returned.stored, stack.capacity);
        return simulateStack;
    }

    @Override
    public StoredFluidStack removeFluids(StoredFluidStack remove, TileEntity tile, EnumFacing face, ActionType type, ITankFilter filter) {
        if (filter == null || filter.allowed(remove.fluid)) {
            for (ISonarFluidHandler provider : SonarCore.fluidHandlers) {
                if (!provider.canHandleFluids(tile, face)) continue;
                if ((remove = provider.removeStack(remove, tile, face, type)) != null) break;
                return null;
            }
        }
        return remove;
    }

    @Override
    public StoredFluidStack addFluids(StoredFluidStack add, TileEntity tile, EnumFacing face, ActionType type, ITankFilter filter) {
        if (filter == null || filter.allowed(add.fluid)) {
            for (ISonarFluidHandler provider : SonarCore.fluidHandlers) {
                if (!provider.canHandleFluids(tile, face)) continue;
                if ((add = provider.addStack(add, tile, face, type)) != null) break;
                return null;
            }
        }
        return add;
    }

    @Override
    public void transferFluids(TileEntity from, TileEntity to, EnumFacing dirFrom, EnumFacing dirTo, ITankFilter filter) {
        if (from != null && to != null) {
            ArrayList stacks = Lists.newArrayList();
            List<ISonarFluidHandler> handlers = SonarCore.fluidHandlers;
            for (ISonarFluidHandler handler : handlers) {
                if (!handler.canHandleFluids(from, dirFrom)) continue;
                handler.getFluids(stacks, from, dirFrom);
                break;
            }
            if (stacks.isEmpty()) {
                return;
            }
            for (StoredFluidStack stack : stacks) {
                StoredFluidStack removed = this.removeFluids(stack.copy(), from, dirFrom, ActionType.SIMULATE, filter);
                removed = this.getStackToAdd(stack.getStackSize(), stack.copy(), removed);
                if (removed == null) continue;
                StoredFluidStack add = this.addFluids(removed.copy(), to, dirTo, ActionType.SIMULATE, filter);
                add = this.getStackToAdd(removed.getStackSize(), removed.copy(), add);
                if (add == null) continue;
                this.removeFluids(add.copy(), from, dirFrom, ActionType.PERFORM, filter);
                this.addFluids(removed.copy(), to, dirTo, ActionType.PERFORM, filter);
            }
        }
    }

    public static StoredFluidStack addStack(StoredFluidStack add, IFluidHandler handler, EnumFacing dir, ActionType action) {
        add.stored = add.stored - (long)handler.fill(add.getFullStack(), !action.shouldSimulate());
        return add;
    }

    public static StoredFluidStack removeStack(StoredFluidStack remove, IFluidHandler handler, EnumFacing dir, ActionType action) {
        FluidStack drained = null;
        drained = handler.drain(remove.getFullStack(), !action.shouldSimulate());
        remove.stored = remove.stored - (drained != null ? (long)drained.amount : 0L);
        return remove;
    }

    public static StorageSize getFluids(List<StoredFluidStack> fluids, IFluidHandler handler, EnumFacing dir) {
        long stored = 0L;
        long maxStorage = 0L;
        IFluidTankProperties[] tankInfo = handler.getTankProperties();
        if (tankInfo != null) {
            for (IFluidTankProperties info : tankInfo) {
                FluidStack contents = info.getContents();
                if (contents != null && contents.amount != 0) {
                    stored += (long)contents.amount;
                    fluids.add(new StoredFluidStack(contents, info.getCapacity()));
                }
                maxStorage += (long)info.getCapacity();
            }
        }
        return new StorageSize(stored, maxStorage);
    }

    public static interface ITankFilter {
        public boolean allowed(FluidStack var1);
    }
}

