/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileTeruTeruBozu;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockTeruTeruBozu
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.01, 0.25, 0.75, 0.99, 0.75);

    public BlockTeruTeruBozu() {
        super(Material.field_151580_n, "teruTeruBozu");
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity e) {
        EntityItem item;
        ItemStack stack;
        if (!world.field_72995_K && e instanceof EntityItem && (this.isSunflower(stack = (item = (EntityItem)e).func_92059_d()) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                e.func_70106_y();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing s, float xs, float ys, float zs) {
        if (stack != null && (this.isSunflower(stack) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean isSunflower(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150398_cm) && stack.func_77952_i() == 0;
    }

    private boolean isBlueOrchid(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150328_O) && stack.func_77952_i() == 1;
    }

    private boolean removeRain(World world) {
        if (world.func_72896_J()) {
            world.func_72912_H().func_76084_b(false);
            TileTeruTeruBozu.resetRainTime(world);
            return true;
        }
        return false;
    }

    private boolean startRain(World world) {
        if (!world.func_72896_J()) {
            if (world.field_73012_v.nextInt(10) == 0) {
                world.func_72912_H().func_76084_b(true);
                TileTeruTeruBozu.resetRainTime(world);
            }
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return world.func_72896_J() ? 15 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTeruTeruBozu();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.teruTeruBozu;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerCustomItemblock(this, "teru_teru_bozu");
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)this), (int)0, TileTeruTeruBozu.class);
    }
}

