/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.phylogeny.extrabitmanipulation.armor.ArmorItem;
import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import mod.chiselsandbits.render.BaseBakedPerspectiveModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ChiseledArmorStackHandeler
extends ItemOverrideList {
    private static final Map<NBTTagCompound, IBakedModel> movingPartsModelMap = new HashMap<NBTTagCompound, IBakedModel>();

    public ChiseledArmorStackHandeler() {
        super(new ArrayList());
    }

    public static void clearModelMap() {
        movingPartsModelMap.clear();
    }

    public static void removeFromModelMap(NBTTagCompound nbt) {
        movingPartsModelMap.remove(nbt);
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        NBTTagCompound armorNbt;
        if (stack.func_77942_o() && (armorNbt = ItemStackHelper.getArmorData(stack.func_77978_p())).func_74767_n("notEmpty")) {
            ItemChiseledArmor armor = (ItemChiseledArmor)stack.func_77973_b();
            Object model = movingPartsModelMap.get(armorNbt);
            if (model == null) {
                DataChiseledArmorPiece armorPiece = new DataChiseledArmorPiece(stack.func_77978_p(), ItemChiseledArmor.ArmorType.values()[armorNbt.func_74762_e("type")]);
                List<GlOperation> glOperationsPre = armorPiece.getGlobalGlOperations(true);
                List<GlOperation> glOperationsPost = armorPiece.getGlobalGlOperations(false);
                ArrayList[] quadsFace = new ArrayList[EnumFacing.field_82609_l.length];
                ArrayList<BakedQuad> quadsGeneric = new ArrayList<BakedQuad>();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    quadsFace[facing.ordinal()] = new ArrayList();
                }
                float[] bounds = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
                boolean found = false;
                for (int p = 0; p < 3; ++p) {
                    float offset;
                    float scale = 1.0f + Configs.armorZFightingBufferScale + (armor.field_77881_a == ItemChiseledArmor.ArmorType.BOOTS && p == 0 || armor.field_77881_a == ItemChiseledArmor.ArmorType.LEGGINGS && p == 1 ? Configs.armorZFightingBufferScaleRightLegOrFoot : 0.0f);
                    float f = armor.field_77881_a == ItemChiseledArmor.ArmorType.CHESTPLATE ? 6.0f : (offset = armor.field_77881_a == ItemChiseledArmor.ArmorType.BOOTS ? 3.9f : 2.0f);
                    float offsetX = p == 0 ? 0.0f : 0.0625f * (p == 1 ? offset : -offset);
                    float offsetY = armor.field_77881_a == ItemChiseledArmor.ArmorType.LEGGINGS && p == 0 ? 1.0f : 0.0f;
                    for (ArmorItem armorItem : armorPiece.getArmorItemsForPart(p)) {
                        if (armorItem.getStack() == null) continue;
                        List<GlOperation> glOperationsItem = armorItem.getGlOperations();
                        model = ClientHelper.getRenderItem().func_184393_a(armorItem.getStack(), null, (EntityLivingBase)ClientHelper.getPlayer());
                        Matrix4f matrix = this.generateMatrix(glOperationsPre, glOperationsItem, glOperationsPost);
                        try {
                            for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
                                quadsGeneric.add(this.createTransformedQuad(quad, null, armorItem.getStack(), bounds, scale, offsetX, offsetY, matrix));
                                found = true;
                            }
                            for (EnumFacing facing : EnumFacing.values()) {
                                for (BakedQuad quad : model.func_188616_a(null, facing, 0L)) {
                                    quadsFace[facing.ordinal()].add(this.createTransformedQuad(quad, facing, armorItem.getStack(), bounds, scale, offsetX, offsetY, matrix));
                                    found = true;
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (found) {
                    this.scaleAndCenterQuads(quadsFace, quadsGeneric, bounds);
                    model = new ChiseledArmorBakedModel(quadsFace, quadsGeneric);
                    movingPartsModelMap.put(armorNbt, (IBakedModel)model);
                }
            }
            return Configs.armorStackModelRenderMode == ArmorStackModelRenderMode.ALWAYS_CUSTOM_MODEL || Configs.armorStackModelRenderMode.ordinal() < 2 && (Configs.armorStackModelRenderMode == ArmorStackModelRenderMode.CUSTOM_MODEL_IF_HOLDING_SHIFT ? GuiScreen.func_146272_n() : !GuiScreen.func_146272_n()) ? model : armor.getItemModel();
        }
        return ((ItemChiseledArmor)stack.func_77973_b()).getItemModel();
    }

    private Matrix4f generateMatrix(List<GlOperation> glOperationsPre, List<GlOperation> glOperationsItem, List<GlOperation> glOperationsPost) {
        Matrix4f temp;
        Matrix4f matrix = new Matrix4f();
        matrix.setIdentity();
        ArrayList<GlOperation> glOperations = new ArrayList<GlOperation>();
        glOperations.addAll(glOperationsPre);
        glOperations.addAll(glOperationsItem);
        glOperations.addAll(glOperationsPost);
        for (GlOperation glOperation : glOperations) {
            switch (glOperation.getType()) {
                case ROTATION: {
                    temp = new Matrix4f();
                    temp.set(new AxisAngle4f(glOperation.getX(), glOperation.getY(), glOperation.getZ(), (float)Math.toRadians(glOperation.getAngle())));
                    matrix.mul(temp);
                    break;
                }
                case TRANSLATION: {
                    temp = new Matrix4f();
                    temp.set(new Vector3f(glOperation.getX(), glOperation.getY(), glOperation.getZ()));
                    matrix.mul(temp);
                    break;
                }
                case SCALE: {
                    Vector3f scaleVec = new Vector3f(glOperation.getX(), glOperation.getY(), glOperation.getZ());
                    temp = new Matrix4f();
                    temp.setIdentity();
                    temp.m00 = scaleVec.x;
                    temp.m11 = scaleVec.y;
                    temp.m22 = scaleVec.z;
                    matrix.mul(temp);
                }
            }
        }
        temp = new Matrix4f();
        temp.set(new Vector3f(-0.5f, -0.5f, -0.5f));
        matrix.mul(temp);
        return matrix;
    }

    private void scaleAndCenterQuads(List<BakedQuad>[] quadsFace, List<BakedQuad> quadsGeneric, float[] bounds) {
        float dimX = bounds[3] - bounds[0];
        float dimY = bounds[4] - bounds[1];
        float dimZ = bounds[5] - bounds[2];
        float scale = 1.0f / Math.max(dimX, Math.max(dimY, dimZ));
        float translationX = 0.5f - (bounds[3] + bounds[0]) * 0.5f * scale;
        float translationY = 0.5f - (bounds[4] + bounds[1]) * 0.5f * scale;
        float translationZ = 0.5f - (bounds[5] + bounds[2]) * 0.5f * scale;
        for (BakedQuad quad : quadsGeneric) {
            this.scaleAndCenterQuad(quad, scale, translationX, translationY, translationZ);
        }
        for (EnumFacing facing : EnumFacing.values()) {
            for (BakedQuad quad : quadsFace[facing.ordinal()]) {
                this.scaleAndCenterQuad(quad, scale, translationX, translationY, translationZ);
            }
        }
    }

    private void scaleAndCenterQuad(BakedQuad quad, float scale, float translationX, float translationY, float translationZ) {
        int size = quad.getFormat().func_181719_f();
        int[] data = quad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            int index = size * i;
            data[index] = Float.floatToRawIntBits(Float.intBitsToFloat(data[index]) * scale + translationX);
            data[index + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(data[index + 1]) * scale + translationY);
            data[index + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(data[index + 2]) * scale + translationZ);
        }
    }

    private BakedQuad createTransformedQuad(BakedQuad quad, EnumFacing facing, ItemStack stack, float[] bounds, float scale, float offsetX, float offsetY, Matrix4f matrix) {
        int size = quad.getFormat().func_181719_f();
        int[] data = (int[])quad.func_178209_a().clone();
        for (int i = 0; i < 4; ++i) {
            int index = size * i;
            float x = Float.intBitsToFloat(data[index]);
            float y = Float.intBitsToFloat(data[index + 1]);
            float z = Float.intBitsToFloat(data[index + 2]);
            Vector4f vec = new Vector4f(x, y, z, 1.0f);
            matrix.transform((Tuple4f)vec);
            x = vec.x * scale + offsetX;
            y = vec.y * scale + offsetY;
            z = vec.z * scale;
            if (x < bounds[0]) {
                bounds[0] = x;
            }
            if (x > bounds[3]) {
                bounds[3] = x;
            }
            if (y < bounds[1]) {
                bounds[1] = y;
            }
            if (y > bounds[4]) {
                bounds[4] = y;
            }
            if (z < bounds[2]) {
                bounds[2] = z;
            }
            if (z > bounds[5]) {
                bounds[5] = z;
            }
            data[index] = Float.floatToRawIntBits(x);
            data[index + 1] = Float.floatToRawIntBits(y);
            data[index + 2] = Float.floatToRawIntBits(z);
        }
        return new BakedQuad(data, quad.func_178211_c() == -1 ? -1 : ClientHelper.getItemColors().func_186728_a(stack, quad.func_178211_c()), facing, quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static enum ArmorStackModelRenderMode {
        DEFAULT_MODEL_IF_HOLDING_SHIFT,
        CUSTOM_MODEL_IF_HOLDING_SHIFT,
        ALWAYS_CUSTOM_MODEL,
        ALWAYS_DEFAULT_MODEL;

    }

    public static class ChiseledArmorBakedModel
    extends BaseBakedPerspectiveModel {
        private static Matrix4f ground;
        private static Matrix4f fixed;
        private final ItemOverrideList overrides = new ChiseledArmorStackHandeler();
        private List<BakedQuad>[] face;
        private List<BakedQuad> generic;

        public ChiseledArmorBakedModel(List<BakedQuad>[] face, List<BakedQuad> generic) {
            this();
            this.face = face;
            this.generic = generic;
        }

        public ChiseledArmorBakedModel() {
            if (ground == null) {
                ground = this.createMatrix(ItemCameraTransforms.TransformType.GROUND);
                fixed = this.createMatrix(ItemCameraTransforms.TransformType.FIXED);
            }
        }

        private Matrix4f createMatrix(ItemCameraTransforms.TransformType transformType) {
            Matrix4f matrix = new Matrix4f();
            matrix.set(1.35f);
            matrix.mul((Matrix4f)this.handlePerspective(transformType).getRight());
            return matrix;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (ground != null && fixed != null && (cameraTransformType == ItemCameraTransforms.TransformType.GROUND || cameraTransformType == ItemCameraTransforms.TransformType.FIXED)) {
                return new ImmutablePair((Object)this, (Object)(cameraTransformType == ItemCameraTransforms.TransformType.GROUND ? ground : fixed));
            }
            return super.handlePerspective(cameraTransformType);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.generic == null ? Collections.EMPTY_LIST : (side != null ? this.face[side.ordinal()] : this.generic);
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

