/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import gnu.trove.set.hash.TCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.client.DeduplicatingStorageTrove;
import pl.asie.foamfix.client.FoamyItemLayerModel;
import pl.asie.foamfix.client.IDeduplicatingStorage;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.HashingStrategies;
import pl.asie.foamfix.util.MethodHandleHelper;

public class Deduplicator {
    private static final Set<Class> BLACKLIST_CLASS = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Set<Class> TRIM_ARRAYS_CLASSES = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Map<Class, Set<MethodHandle[]>> CLASS_FIELDS = new IdentityHashMap<Class, Set<MethodHandle[]>>();
    private static final Map<Class, MethodHandle> COLLECTION_CONSTRUCTORS = new IdentityHashMap<Class, MethodHandle>();
    private static final MethodHandle FIELD_UNPACKED_DATA_GETTER = MethodHandleHelper.findFieldGetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle FIELD_UNPACKED_DATA_SETTER = MethodHandleHelper.findFieldSetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle IPAM_MW_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter(IPerspectiveAwareModel.MapWrapper.class, "transforms");
    private static final MethodHandle IPAM_MW_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter(IPerspectiveAwareModel.MapWrapper.class, "transforms");
    private static final MethodHandle BIM_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter("net.minecraftforge.client.model.ItemLayerModel$BakedItemModel", "transforms");
    private static final MethodHandle BIM_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter("net.minecraftforge.client.model.ItemLayerModel$BakedItemModel", "transforms");
    public int successfuls = 0;
    public int maxRecursion = 0;
    private final IDeduplicatingStorage<float[]> FLOATA_STORAGE = new DeduplicatingStorageTrove<float[]>(HashingStrategies.FLOAT_ARRAY);
    private final IDeduplicatingStorage<float[][]> FLOATAA_STORAGE = new DeduplicatingStorageTrove<float[][]>(HashingStrategies.FLOAT_ARRAY_ARRAY);
    private final IDeduplicatingStorage OBJECT_STORAGE = new DeduplicatingStorageTrove(HashingStrategies.GENERIC);
    private final IDeduplicatingStorage<ItemCameraTransforms> ICT_STORAGE = new DeduplicatingStorageTrove<ItemCameraTransforms>(HashingStrategies.ITEM_CAMERA_TRANSFORMS);
    private final Set<Object> deduplicatedObjects = new TCustomHashSet(HashingStrategies.IDENTITY);

    private static void addClassFromName(Set<Class> set, String className) {
        try {
            set.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private boolean shouldCheckClass(Class c) {
        if (BLACKLIST_CLASS.contains(c)) {
            return false;
        }
        if (c.isPrimitive() || c.isEnum() || c.isArray() && !this.shouldCheckClass(c.getComponentType())) {
            BLACKLIST_CLASS.add(c);
            return false;
        }
        return true;
    }

    public void addObject(Object o) {
        this.OBJECT_STORAGE.deduplicate(o);
    }

    public void addObjects(Collection coll) {
        for (Object o : coll) {
            this.OBJECT_STORAGE.deduplicate(o);
        }
    }

    public Object deduplicate0(Object o) {
        Object n = o;
        int size = 0;
        if (o instanceof float[]) {
            size = 24 + ((float[])o).length * 4;
            n = this.FLOATA_STORAGE.deduplicate((float[])o);
        } else if (o instanceof float[][]) {
            size = 16 + ((float[][])o).length * 4;
            float[][] arr = this.FLOATAA_STORAGE.deduplicate((float[][])o);
            if (arr != o) {
                n = arr;
                this.successfuls += arr.length;
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (float[])this.deduplicate0(arr[i]);
                }
            }
        } else if (o instanceof float[][][]) {
            float[][][] arr = (float[][][])o;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (float[][])this.deduplicate0(arr[i]);
            }
        } else if (o instanceof ImmutableList || o instanceof ImmutableSet || o instanceof ImmutableMap) {
            n = this.OBJECT_STORAGE.deduplicate(o);
        } else {
            Class<?> c = o.getClass();
            if (ResourceLocation.class == c || ModelResourceLocation.class == c) {
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (TRSRTransformation.class == c) {
                size = 257;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (ItemCameraTransforms.class == c) {
                size = 80;
                n = this.ICT_STORAGE.deduplicate((ItemCameraTransforms)o);
            } else {
                return null;
            }
        }
        if (n != o) {
            ++this.successfuls;
            FoamFixShared.ramSaved += size;
        }
        return n;
    }

    public Object deduplicateObject(Object o, int recursion) {
        block61: {
            Class<?> c;
            block64: {
                block63: {
                    Object b;
                    block62: {
                        block60: {
                            if (o == null || recursion > this.maxRecursion) {
                                return o;
                            }
                            c = o.getClass();
                            if (!this.shouldCheckClass(c)) {
                                return o;
                            }
                            if (!this.deduplicatedObjects.add(o)) {
                                return o;
                            }
                            if (o instanceof IBakedModel) {
                                Object toD;
                                Object to;
                                if (o instanceof IPerspectiveAwareModel.MapWrapper) {
                                    try {
                                        to = IPAM_MW_TRANSFORMS_GETTER.invoke(o);
                                        toD = this.deduplicate0(to);
                                        if (toD != null && to != toD) {
                                            IPAM_MW_TRANSFORMS_SETTER.invoke(o, toD);
                                        }
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                } else if ("net.minecraftforge.client.model.ItemLayerModel$BakedItemModel".equals(c.getName())) {
                                    try {
                                        to = BIM_TRANSFORMS_GETTER.invoke(o);
                                        toD = this.deduplicate0(to);
                                        if (toD != null && to != toD) {
                                            BIM_TRANSFORMS_SETTER.invoke(o, toD);
                                        }
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                }
                            }
                            if (c != UnpackedBakedQuad.class) break block60;
                            try {
                                float[][][] array = FIELD_UNPACKED_DATA_GETTER.invokeExact((UnpackedBakedQuad)o);
                                this.deduplicate0(array);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            break block61;
                        }
                        if (o instanceof ResourceLocation || o instanceof TRSRTransformation) {
                            return this.deduplicate0(o);
                        }
                        if (c == ItemCameraTransforms.class) {
                            Object d = this.deduplicate0(o);
                            if (d != o) {
                                return d;
                            }
                            return o;
                        }
                        if (!(o instanceof Item) && !(o instanceof Block) && !(o instanceof World) && !(o instanceof Entity) && !(o instanceof Logger) && !(o instanceof IRegistry)) break block62;
                        BLACKLIST_CLASS.add(c);
                        break block61;
                    }
                    if (o != ItemOverrideList.field_188022_a && c == ItemOverrideList.class && ((ItemOverrideList)o).getOverrides().isEmpty()) {
                        ++this.successfuls;
                        return ItemOverrideList.field_188022_a;
                    }
                    if (!(o instanceof Optional)) break block63;
                    Optional opt = (Optional)o;
                    if (opt.isPresent() && (b = this.deduplicateObject(opt.get(), recursion + 1)) != null && b != opt.get()) {
                        return Optional.of((Object)b);
                    }
                    break block61;
                }
                if (!(o instanceof Multimap)) break block64;
                if (o instanceof ImmutableMultimap) break block61;
                for (Object key : ((Multimap)o).keySet()) {
                    ArrayList l = Lists.newArrayList((Iterable)((Multimap)o).values());
                    for (int i = 0; i < l.size(); ++i) {
                        l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                    }
                    ((Multimap)o).replaceValues(key, (Iterable)l);
                }
                break block61;
            }
            if (o instanceof Map) {
                if (o instanceof ImmutableMap) {
                    ImmutableMap im = (ImmutableMap)o;
                    HashMap newMap = new HashMap();
                    boolean deduplicated = false;
                    UnmodifiableIterator i = im.keySet().iterator();
                    while (i.hasNext()) {
                        Object key;
                        Object a = im.get(key = i.next());
                        Object b = this.deduplicateObject(a, recursion + 1);
                        newMap.put(key, b != null ? b : a);
                        if (b == null || b == a) continue;
                        deduplicated = true;
                    }
                    if (deduplicated) {
                        return ImmutableMap.copyOf(newMap);
                    }
                } else {
                    for (Object key : ((Map)o).keySet()) {
                        Object value = ((Map)o).get(key);
                        Object valueD = this.deduplicateObject(value, recursion + 1);
                        if (valueD == null || value == valueD) continue;
                        ((Map)o).put(key, valueD);
                    }
                }
            } else if (o instanceof List) {
                if (o instanceof ImmutableList) {
                    ImmutableList il = (ImmutableList)o;
                    ArrayList<Object> newList = new ArrayList<Object>();
                    boolean deduplicated = false;
                    for (int i = 0; i < il.size(); ++i) {
                        Object a = il.get(i);
                        Object b = this.deduplicateObject(a, recursion + 1);
                        newList.add(b != null ? b : a);
                        if (b == null || b == a) continue;
                        deduplicated = true;
                    }
                    if (deduplicated) {
                        return ImmutableList.copyOf(newList);
                    }
                } else {
                    List l = (List)o;
                    for (int i = 0; i < l.size(); ++i) {
                        l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                    }
                }
            } else if (o instanceof Collection) {
                MethodHandle constructor;
                if (!COLLECTION_CONSTRUCTORS.containsKey(c)) {
                    try {
                        COLLECTION_CONSTRUCTORS.put(c, MethodHandles.publicLookup().findConstructor(c, MethodType.methodType(Void.TYPE)));
                    }
                    catch (Exception e) {
                        COLLECTION_CONSTRUCTORS.put(c, null);
                    }
                }
                if ((constructor = COLLECTION_CONSTRUCTORS.get(c)) != null) {
                    try {
                        Collection nc = constructor.invoke();
                        for (Object o1 : (Collection)o) {
                            nc.add(this.deduplicateObject(o1, recursion + 1));
                        }
                        return nc;
                    }
                    catch (Throwable nc) {
                        // empty catch block
                    }
                }
                for (Object o1 : (Collection)o) {
                    this.deduplicateObject(o1, recursion + 1);
                }
            } else if (c.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    Object entry = Array.get(o, i);
                    Object entryD = this.deduplicateObject(entry, recursion + 1);
                    if (entryD == null || entry == entryD) continue;
                    Array.set(o, i, entryD);
                }
            } else {
                if (!CLASS_FIELDS.containsKey(c)) {
                    ImmutableSet.Builder fsBuilder = ImmutableSet.builder();
                    Class<?> cc = c;
                    do {
                        for (Field f : cc.getDeclaredFields()) {
                            f.setAccessible(true);
                            if ((f.getModifiers() & 8) != 0 || !this.shouldCheckClass(f.getType())) continue;
                            try {
                                fsBuilder.add((Object)new MethodHandle[]{MethodHandles.lookup().unreflectGetter(f), MethodHandles.lookup().unreflectSetter(f)});
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    } while ((cc = cc.getSuperclass()) != Object.class);
                    CLASS_FIELDS.put(c, (Set<MethodHandle[]>)fsBuilder.build());
                }
                for (MethodHandle[] mh : CLASS_FIELDS.get(c)) {
                    try {
                        Object value = mh[0].invoke(o);
                        Object valueD = this.deduplicateObject(value, recursion + 1);
                        if (TRIM_ARRAYS_CLASSES.contains(c) && valueD instanceof ArrayList) {
                            ((ArrayList)valueD).trimToSize();
                        }
                        if (valueD == null || value == valueD) continue;
                        mh[1].invoke(o, valueD);
                    }
                    catch (IllegalAccessException value) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        return o;
    }

    static {
        TRIM_ARRAYS_CLASSES.add(ItemOverrideList.class);
        TRIM_ARRAYS_CLASSES.add(FoamyItemLayerModel.DynamicItemModel.class);
        TRIM_ARRAYS_CLASSES.add(SimpleBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(WeightedBakedModel.class);
        BLACKLIST_CLASS.add(Object.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(String.class);
        BLACKLIST_CLASS.add(Integer.class);
        BLACKLIST_CLASS.add(Long.class);
        BLACKLIST_CLASS.add(Byte.class);
        BLACKLIST_CLASS.add(Boolean.class);
        BLACKLIST_CLASS.add(Float.class);
        BLACKLIST_CLASS.add(Double.class);
        BLACKLIST_CLASS.add(Short.class);
        BLACKLIST_CLASS.add(TextureAtlasSprite.class);
        BLACKLIST_CLASS.add(ItemStack.class);
        BLACKLIST_CLASS.add(Gson.class);
        BLACKLIST_CLASS.add(ModelLoader.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(BlockPart.class);
        BLACKLIST_CLASS.add(Minecraft.class);
        BLACKLIST_CLASS.add(BlockModelShapes.class);
        BLACKLIST_CLASS.add(ModelManager.class);
        BLACKLIST_CLASS.add(Logger.class);
        BLACKLIST_CLASS.add(Joiner.class);
        BLACKLIST_CLASS.add(Tessellator.class);
        BLACKLIST_CLASS.add(Cache.class);
        BLACKLIST_CLASS.add(LoadingCache.class);
        BLACKLIST_CLASS.add(VertexFormatElement.class);
        BLACKLIST_CLASS.add(BakedQuad.class);
        Deduplicator.addClassFromName(BLACKLIST_CLASS, "net.minecraft.client.renderer.VertexBuffer");
        Deduplicator.addClassFromName(BLACKLIST_CLASS, "net.minecraft.client.renderer.BufferBuilder");
    }
}

