/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.reference.Reference;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.model.PerspectiveAwareModelProperties;
import codechicken.lib.model.bakery.ItemModelBakery;
import codechicken.lib.model.blockbakery.IItemBakery;
import codechicken.lib.texture.TextureUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class EnderPouchBakery
implements IItemBakery,
TextureUtils.IIconRegister {
    public static final EnderPouchBakery INSTANCE = new EnderPouchBakery();
    public static TextureAtlasSprite[][] BAG_TEXTURES;
    public static TextureAtlasSprite[][] COLOUR_TEXTURES;

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face == null) {
            Frequency frequency = Frequency.fromItemStack(stack);
            boolean open = ((EnderItemStorage)EnderStorageManager.instance(true).getStorage(frequency, "item")).openCount() > 0;
            TextureAtlasSprite bagTexture = BAG_TEXTURES[frequency.hasOwner() ? 1 : 0][open ? 1 : 0];
            quads.addAll(ItemModelBakery.bakeItem((List)ImmutableList.of((Object)bagTexture, (Object)COLOUR_TEXTURES[0][frequency.left], (Object)COLOUR_TEXTURES[1][frequency.middle], (Object)COLOUR_TEXTURES[2][frequency.right])));
        }
        return quads;
    }

    public PerspectiveAwareModelProperties getModelProperties(ItemStack stack) {
        return PerspectiveAwareModelProperties.DEFAULT_ITEM;
    }

    public void registerIcons(TextureMap map) {
        String POUCH_PREFIX = Reference.MOD_PREFIX + "items/pouch/";
        String BUTTONS_PREFIX = POUCH_PREFIX + "buttons/";
        String[] position_prefixes = new String[]{"left/", "middle/", "right/"};
        BAG_TEXTURES = new TextureAtlasSprite[2][2];
        COLOUR_TEXTURES = new TextureAtlasSprite[3][16];
        EnderPouchBakery.BAG_TEXTURES[0][0] = EnderPouchBakery.register(map, POUCH_PREFIX + "closed");
        EnderPouchBakery.BAG_TEXTURES[0][1] = EnderPouchBakery.register(map, POUCH_PREFIX + "open");
        EnderPouchBakery.BAG_TEXTURES[1][0] = EnderPouchBakery.register(map, POUCH_PREFIX + "owned_closed");
        EnderPouchBakery.BAG_TEXTURES[1][1] = EnderPouchBakery.register(map, POUCH_PREFIX + "owned_open");
        for (int i = 0; i < 3; ++i) {
            for (EnumColour colour : EnumColour.values()) {
                EnderPouchBakery.COLOUR_TEXTURES[i][colour.ordinal()] = EnderPouchBakery.register(map, BUTTONS_PREFIX + position_prefixes[i] + colour.getMinecraftName());
            }
        }
    }

    private static TextureAtlasSprite register(TextureMap map, String sprite) {
        return map.func_174942_a(new ResourceLocation(sprite));
    }
}

