/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum PreviewType {
    PANEL(16.0f, PreviewType.generateBetween(0, 1, 0, 2, 3, 0)),
    HOLLOW(16.0f, (BlockPos[])ArrayUtils.removeElement((Object[])PreviewType.generateBetween(0, 1, 0, 2, 3, 0), (Object)new BlockPos(1, 2, 0))),
    PLUS(20.0f, new BlockPos(1, 1, 0), new BlockPos(1, 2, 0), new BlockPos(2, 2, 0), new BlockPos(0, 2, 0), new BlockPos(1, 3, 0)),
    SINGLE(39.0f, new BlockPos(1, 2, 0));

    private float scale;
    private Set<BlockPos> positions;

    @Nonnull
    private static BlockPos[] generateBetween(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos[] ret = new BlockPos[(maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1)];
        int i = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ret[i++] = new BlockPos(x, y, z);
                }
            }
        }
        return ret;
    }

    private PreviewType(float scale, BlockPos ... positions) {
        this.scale = scale;
        this.positions = ImmutableSet.copyOf((Object[])positions);
    }

    public String toString() {
        return StringUtils.capitalize((String)this.name().toLowerCase(Locale.US));
    }

    public float getScale() {
        return this.scale;
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }
}

