/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.Chisel;
import team.chisel.api.chunkdata.ChunkData;
import team.chisel.client.ChiselPackReloadListener;
import team.chisel.client.TextureStitcher;
import team.chisel.client.handler.DebugHandler;
import team.chisel.client.render.ChiselModelRegistry;
import team.chisel.client.render.ModelLoaderChisel;
import team.chisel.common.CommonProxy;
import team.chisel.ctm.client.texture.ctx.OffsetProviderRegistry;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean ctmPresent = true;

    @Override
    public void construct(FMLPreInitializationEvent event) {
        super.construct(event);
        if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            Field missingException = ReflectionHelper.findField(FMLClientHandler.class, (String[])new String[]{"modsMissing"});
            VersionRange range = VersionRange.createFromVersionSpec((String)"[MC1.10.2-0.2.0.18,)");
            if (!Loader.isModLoaded((String)"ctm") || !range.containsVersion(((ModContainer)Loader.instance().getIndexedModList().get("ctm")).getProcessedVersion())) {
                if (missingException.get(FMLClientHandler.instance()) == null) {
                    missingException.set(FMLClientHandler.instance(), new MissingModsException((Set)ImmutableSet.of((Object)new DefaultArtifactVersion("CTM", range)), "chisel", "Chisel"));
                }
                this.ctmPresent = false;
            }
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (this.isCTMPresent()) {
            this.preInit_impl();
        }
    }

    @Optional.Method(modid="ctm")
    private void preInit_impl() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelLoaderChisel.INSTANCE);
        ModelLoader.setCustomModelResourceLocation((Item)Chisel.itemChiselIron, (int)0, (ModelResourceLocation)new ModelResourceLocation(Chisel.itemChiselIron.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Chisel.itemChiselDiamond, (int)0, (ModelResourceLocation)new ModelResourceLocation(Chisel.itemChiselDiamond.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Chisel.itemChiselHitech, (int)0, (ModelResourceLocation)new ModelResourceLocation(Chisel.itemChiselHitech.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Chisel.itemOffsetTool, (int)0, (ModelResourceLocation)new ModelResourceLocation(Chisel.itemOffsetTool.getRegistryName(), "inventory"));
        MinecraftForge.EVENT_BUS.register((Object)new TextureStitcher());
        MinecraftForge.EVENT_BUS.register((Object)ChiselModelRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new DebugHandler());
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
            manager.func_110542_a((IResourceManagerReloadListener)ChiselPackReloadListener.INSTANCE);
        }
        OffsetProviderRegistry.INSTANCE.registerProvider((world, pos) -> ChunkData.getOffsetForChunk(world, pos).getOffset());
    }

    @Override
    public void init() {
    }

    @Override
    public void preTextureStitch() {
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public boolean isCTMPresent() {
        return this.ctmPresent;
    }
}

