/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.Features;
import team.chisel.api.ChiselAPIProps;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.gui.ChiselGuiHandler;
import team.chisel.client.gui.PacketChiselButton;
import team.chisel.client.gui.PacketHitechSettings;
import team.chisel.common.CommonProxy;
import team.chisel.common.Reference;
import team.chisel.common.carving.Carving;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselBlocks;
import team.chisel.common.init.ChiselFuelHandler;
import team.chisel.common.integration.imc.IMCHandler;
import team.chisel.common.item.ChiselController;
import team.chisel.common.item.ItemChisel;
import team.chisel.common.item.ItemOffsetTool;
import team.chisel.common.util.GenerationHandler;
import team.chisel.common.util.PerChunkData;

@Mod(modid="chisel", version="MC1.10.2-0.0.14.33", name="Chisel", acceptedMinecraftVersions="[1.9.4, 1.11)")
public class Chisel
implements Reference {
    public static final Logger logger = LogManager.getLogger((String)"Chisel");
    @Mod.Instance(value="chisel")
    public static Chisel instance;
    @SidedProxy(clientSide="team.chisel.client.ClientProxy", serverSide="team.chisel.common.CommonProxy", modId="chisel")
    public static CommonProxy proxy;
    @Nonnull
    public static ItemChisel itemChiselIron;
    @Nonnull
    public static ItemChisel itemChiselDiamond;
    @Nonnull
    public static ItemChisel itemChiselHitech;
    @Nonnull
    public static ItemOffsetTool itemOffsetTool;
    public static final boolean debug = false;
    public static final SimpleNetworkWrapper network;

    public Chisel() {
        CarvingUtils.chisel = Carving.chisel;
        ChiselAPIProps.MOD_ID = "chisel";
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.construct(event);
        File configFile = event.getSuggestedConfigurationFile();
        Configurations.configExists = configFile.exists();
        Configurations.config = new Configuration(configFile);
        Configurations.config.load();
        Configurations.refreshConfig();
        itemChiselIron = new ItemChisel(ItemChisel.ChiselType.IRON);
        itemChiselDiamond = new ItemChisel(ItemChisel.ChiselType.DIAMOND);
        itemChiselHitech = new ItemChisel(ItemChisel.ChiselType.HITECH);
        itemOffsetTool = new ItemOffsetTool();
        GameRegistry.register((IForgeRegistryEntry)itemChiselIron);
        GameRegistry.register((IForgeRegistryEntry)itemChiselDiamond);
        GameRegistry.register((IForgeRegistryEntry)itemChiselHitech);
        GameRegistry.register((IForgeRegistryEntry)itemOffsetTool);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)itemChiselIron, new Object[]{" x", "s ", Character.valueOf('x'), "ingotIron", Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)itemChiselDiamond, new Object[]{" x", "s ", Character.valueOf('x'), "gemDiamond", Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)itemChiselHitech, new Object[]{itemChiselDiamond, "dustRedstone", "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)itemOffsetTool, new Object[]{"-o", "|-", Character.valueOf('o'), Items.field_151079_bi, Character.valueOf('|'), "stickWood", Character.valueOf('-'), "ingotIron"}));
        MinecraftForge.EVENT_BUS.register((Object)PerChunkData.INSTANCE);
        MinecraftForge.EVENT_BUS.register(ChiselController.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GenerationHandler.INSTANCE, (int)2);
        MinecraftForge.EVENT_BUS.register((Object)GenerationHandler.INSTANCE);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)GenerationHandler.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ChiselGuiHandler());
        Features.preInit();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Features.init();
        proxy.init();
        GameRegistry.registerFuelHandler((IFuelHandler)new ChiselFuelHandler());
        Chisel.addCompactorPressRecipe(1000, new ItemStack(Blocks.field_189880_di), new ItemStack((Block)ChiselBlocks.limestoneextra, 1, 7));
        Chisel.addCompactorPressRecipe(1000, new ItemStack((Block)ChiselBlocks.limestoneextra, 1, 7), new ItemStack((Block)ChiselBlocks.marbleextra, 1, 7));
    }

    private static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        NBTTagCompound message = new NBTTagCompound();
        message.func_74768_a("energy", energy);
        message.func_74782_a("input", (NBTBase)new NBTTagCompound());
        message.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(message.func_74775_l("input"));
        output.func_77955_b(message.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"addcompactorpressrecipe", (NBTTagCompound)message);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    public static void debug(String message) {
    }

    public static void debug(float[] array) {
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            IMCHandler.INSTANCE.handleMessage(msg);
        }
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Block block;
            ResourceLocation newRes;
            if (!mapping.resourceLocation.func_110624_b().equals("chisel")) continue;
            String path = mapping.resourceLocation.func_110623_a();
            if (path.endsWith("bookshelf")) {
                path = path.replace("bookshelf", "bookshelf_oak");
                newRes = new ResourceLocation(mapping.resourceLocation.func_110624_b(), path);
                block = (Block)ForgeRegistries.BLOCKS.getValue(newRes);
                if (block == null) continue;
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap(block);
                    continue;
                }
                mapping.remap(Item.func_150898_a((Block)block));
                continue;
            }
            if (!path.toLowerCase().endsWith("bookshelf_dark-oak")) continue;
            path = path.replace("bookshelf_dark-oak", "bookshelf_darkoak");
            newRes = new ResourceLocation(mapping.resourceLocation.func_110624_b(), path);
            block = (Block)ForgeRegistries.BLOCKS.getValue(newRes);
            if (block == null) continue;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                mapping.remap(block);
                continue;
            }
            mapping.remap(Item.func_150898_a((Block)block));
        }
    }

    static {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("chisel");
        network.registerMessage(PacketChiselButton.Handler.class, PacketChiselButton.class, 0, Side.SERVER);
        network.registerMessage(PacketHitechSettings.Handler.class, PacketHitechSettings.class, 1, Side.SERVER);
        network.registerMessage(PerChunkData.MessageChunkDataHandler.class, PerChunkData.MessageChunkData.class, 2, Side.CLIENT);
    }
}

