/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world.placement;

import codechicken.lib.world.placement.BlockPlacementLightingManager;
import codechicken.lib.world.placement.lighting.LightingCalcEntry;
import codechicken.lib.world.placement.lighting.LightingCalcEntryBuilder;
import gnu.trove.set.hash.THashSet;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockPlacementBatcher {
    private final WorldServer serverWorld;
    private THashSet<Chunk> modifiedChunks = new THashSet();
    private LinkedList<LightingCalcEntry> blockLightingUpdates = new LinkedList();

    public BlockPlacementBatcher(WorldServer serverWorld) {
        this.serverWorld = serverWorld;
    }

    public void setBlockState(BlockPos pos, IBlockState newState) {
        if (!this.hasBlockStorage(pos) && newState.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        IBlockState oldState = this.getChunk(pos).func_177435_g(pos);
        if (oldState == newState) {
            return;
        }
        this.setRecalcPrecipitationHeightMap(pos);
        LightingCalcEntryBuilder builder = new LightingCalcEntryBuilder();
        builder.setDimension(this.serverWorld.field_73011_w.getDimension());
        builder.setBasePos(pos);
        builder.setOldState(oldState);
        builder.setNewState(newState);
        builder.setOldLightOpacity(oldState.getLightOpacity((IBlockAccess)this.serverWorld, pos));
        this.createBlockStorageIfNeeded(pos, builder);
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        Chunk chunk = this.getChunk(pos);
        storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, newState);
        this.fireBlockBreak(pos, oldState, newState);
        this.tileEntityRemoveCheck(pos, oldState, newState);
        builder.setNewLightOpacity(newState.getLightOpacity((IBlockAccess)this.serverWorld, pos));
        builder.setSkyLight(chunk.func_177413_a(EnumSkyBlock.SKY, pos));
        builder.setBlockLight(chunk.func_177413_a(EnumSkyBlock.BLOCK, pos));
        this.fireBlockPlace(pos, oldState, newState);
        this.tileEntityPlaceCheck(pos, newState);
        this.setChunkModified(pos);
        this.blockLightingUpdates.add(builder.build());
    }

    public void setChunkModified(BlockPos blockPos) {
        Chunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(Chunk chunk) {
        this.modifiedChunks.add((Object)chunk);
    }

    private Chunk getChunk(BlockPos pos) {
        return this.serverWorld.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    private boolean hasBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.field_76652_q[pos.func_177956_o() >> 4] != null;
    }

    private ExtendedBlockStorage getBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.field_76652_q[pos.func_177956_o() >> 4];
    }

    private void createBlockStorageIfNeeded(BlockPos pos, LightingCalcEntryBuilder builder) {
        Chunk chunk = this.getChunk(pos);
        ExtendedBlockStorage storage = chunk.field_76652_q[pos.func_177956_o() >> 4];
        if (storage == null) {
            int height = chunk.field_76634_f[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF];
            chunk.field_76652_q[pos.func_177956_o() >> 4] = storage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, !this.serverWorld.field_73011_w.func_177495_o());
            builder.setHeight(height);
            if (builder != null && pos.func_177956_o() >= height) {
                builder.setChunkHeightModified();
            }
        }
    }

    private void setRecalcPrecipitationHeightMap(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        int i = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        if (pos.func_177956_o() >= chunk.field_76638_b[i] - 1) {
            chunk.field_76638_b[i] = -999;
        }
    }

    private void fireBlockBreak(BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            oldState.func_177230_c().func_180663_b((World)this.serverWorld, pos, oldState);
        }
    }

    private void fireBlockPlace(BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c() && newState.func_177230_c().hasTileEntity(newState)) {
            oldState.func_177230_c().func_176213_c((World)this.serverWorld, pos, oldState);
        }
    }

    private void tileEntityRemoveCheck(BlockPos pos, IBlockState oldState, IBlockState newState) {
        TileEntity tileEntity = this.getChunk(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tileEntity != null && tileEntity.shouldRefresh((World)this.serverWorld, pos, oldState, newState)) {
            this.serverWorld.func_175713_t(pos);
        }
    }

    private void tileEntityPlaceCheck(BlockPos pos, IBlockState newState) {
        if (newState.func_177230_c().hasTileEntity(newState)) {
            TileEntity tileEntity = this.getChunk(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileEntity == null) {
                tileEntity = newState.func_177230_c().createTileEntity((World)this.serverWorld, newState);
                this.serverWorld.func_175690_a(pos, tileEntity);
            } else {
                tileEntity.func_145836_u();
            }
        }
    }

    public void finish() {
        for (Chunk chunk : this.modifiedChunks) {
            PlayerChunkMap playerChunkMap = this.serverWorld.func_184164_w();
            if (playerChunkMap == null) {
                return;
            }
            PlayerChunkMapEntry watcher = playerChunkMap.func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
            if (watcher == null) continue;
            watcher.func_187267_a((Packet)new SPacketChunkData(chunk, 65535));
        }
        this.modifiedChunks.clear();
        BlockPlacementLightingManager.uploadToLightingQue(this.blockLightingUpdates);
        this.blockLightingUpdates.clear();
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.func_175623_d(pos);
    }

    public IBlockState getBlockState(BlockPos pos) {
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }
}

