/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.util.RenderHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.TextHelper;
import vazkii.psi.client.gui.GuiIntroduction;
import vazkii.psi.client.gui.button.GuiButtonLearn;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PersistencyHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.message.MessageLearnGroup;

public class GuiLeveling
extends GuiScreen {
    public static final ResourceLocation texture = new ResourceLocation("psi:textures/gui/leveling.png");
    public List<String> tooltip = new ArrayList<String>();
    GuiScrollingList listGroups;
    GuiScrollingList listText;
    int xSize;
    int ySize;
    int left;
    int top;
    Spell spellWrapper;
    PlayerDataHandler.PlayerData data;
    List<PieceGroup> groups;
    List<SpellPiece> drawPieces = new ArrayList<SpellPiece>();
    int selected;
    List<String> desc;
    boolean ignoreIntroductionJump;

    public GuiLeveling() {
        this(false);
    }

    public GuiLeveling(boolean skip) {
        this.ignoreIntroductionJump = skip;
    }

    public void func_73866_w_() {
        this.spellWrapper = new Spell();
        this.data = PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g);
        this.initGroupList();
        this.xSize = 256;
        this.ySize = 184;
        this.left = (this.field_146294_l - this.xSize) / 2;
        this.top = (this.field_146295_m - this.ySize) / 2;
        this.listGroups = new GroupList(this.field_146297_k, 120, 168, this.top + 8, this.top + 176, this.left + 8, 26, this.field_146294_l, this.field_146295_m);
        this.select(this.selected);
    }

    public void initGroupList() {
        this.groups = new ArrayList<PieceGroup>();
        String last = this.data.lastSpellGroup;
        PieceGroup lastGroup = PsiAPI.groupsForName.get(last);
        if (lastGroup != null) {
            this.groups.add(lastGroup);
        }
        ArrayList<PieceGroup> available = new ArrayList<PieceGroup>();
        ArrayList<PieceGroup> notAvailable = new ArrayList<PieceGroup>();
        ArrayList<PieceGroup> taken = new ArrayList<PieceGroup>();
        for (PieceGroup group : PsiAPI.groupsForName.values()) {
            if (group == lastGroup) continue;
            if (this.data.isPieceGroupUnlocked(group.name)) {
                taken.add(group);
                continue;
            }
            if (group.isAvailable(this.data)) {
                available.add(group);
                continue;
            }
            notAvailable.add(group);
        }
        Collections.sort(available);
        Collections.sort(notAvailable);
        Collections.sort(taken);
        this.groups.addAll(available);
        this.groups.addAll(notAvailable);
        this.groups.addAll(taken);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int level = this.data.getLevel();
        int points = this.data.getLevelPoints();
        if (!this.ignoreIntroductionJump && (level == 0 && points == 0 || level == 1 && points == 1 && PersistencyHandler.persistentLevel > 1)) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiIntroduction(level == 1));
            return;
        }
        this.tooltip.clear();
        this.func_146276_q_();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.left, this.top, 0, 0, this.xSize, this.ySize);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        PieceGroup group = this.groups.get(this.selected);
        boolean taken = this.data.isPieceGroupUnlocked(group.name);
        group.isAvailable(this.data);
        if (group != null) {
            int lines = (this.drawPieces.size() - 1) / 6 + 1;
            for (int i = 0; i < this.drawPieces.size(); ++i) {
                int x = this.left + 134 + i % 6 * 18;
                int y = this.top + 160 + i / 6 * 18 - (lines - 1) * 18;
                if (i == 0) {
                    this.func_73729_b(x - 1, y - 1, 0, this.ySize, 18, 18);
                }
                SpellPiece piece = this.drawPieces.get(i);
                if (mouseX > x && mouseY > y && mouseX < x + 16 && mouseY < y + 16) {
                    piece.getTooltip(this.tooltip);
                }
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                piece.draw();
                GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            }
            this.field_146297_k.field_71466_p.func_175063_a(I18n.func_74838_a((String)group.getUnlocalizedName()), (float)(this.left + 134), (float)(this.top + 12), 0xFFFFFF);
            if (taken) {
                if (this.listText != null) {
                    boolean unicode = this.field_146289_q.func_82883_a();
                    this.field_146289_q.func_78264_a(true);
                    this.listText.drawScreen(mouseX, mouseY, partialTicks);
                    this.field_146289_q.func_78264_a(unicode);
                }
            } else {
                int colorOff = 0x777777;
                int colorOn = 0x77FF77;
                this.field_146297_k.field_71466_p.func_175063_a(I18n.func_74838_a((String)"psimisc.requirements"), (float)(this.left + 134), (float)(this.top + 32), 0xFFFFFF);
                this.field_146297_k.field_71466_p.func_78276_b(String.format(I18n.func_74838_a((String)"psimisc.levelDisplay"), group.levelRequirement), this.left + 138, this.top + 42, this.data.getLevel() >= group.levelRequirement ? colorOn : colorOff);
                int i = 0;
                for (String s : group.requirements) {
                    PieceGroup reqGroup = PsiAPI.groupsForName.get(s);
                    this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)reqGroup.getUnlocalizedName()), this.left + 138, this.top + 52 + i * 10, this.data.isPieceGroupUnlocked(s) ? colorOn : colorOff);
                    ++i;
                }
            }
        }
        String key = "psimisc.levelInfo";
        if (this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
            key = "psimisc.levelInfoCreative";
        }
        String s = String.format(I18n.func_74838_a((String)key), this.data.getLevel(), this.data.getLevelPoints());
        this.field_146297_k.field_71466_p.func_175063_a(s, (float)(this.left + 4), (float)(this.top + this.ySize + 2), 0xFFFFFF);
        this.listGroups.drawScreen(mouseX, mouseY, partialTicks);
        if (!this.tooltip.isEmpty()) {
            RenderHelper.renderTooltip((int)mouseX, (int)mouseY, this.tooltip);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        PieceGroup group = this.groups.get(this.selected);
        if (group != null) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageLearnGroup(group.name));
            this.data.unlockPieceGroup(group.name);
            Psi.proxy.savePersistency();
            this.initGroupList();
            this.select(0);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        if (this.listText != null) {
            this.listText.handleMouseInput(mouseX, mouseY);
        }
        this.listGroups.handleMouseInput(mouseX, mouseY);
    }

    public void select(int i) {
        boolean taken;
        this.drawPieces.clear();
        PieceGroup group = this.groups.get(this.selected);
        if (group != null) {
            this.addToDrawList(group.mainPiece);
            for (Class<? extends SpellPiece> clazz : group.pieces) {
                if (clazz == group.mainPiece) continue;
                this.addToDrawList(clazz);
            }
        }
        boolean available = (taken = this.data.isPieceGroupUnlocked(group.name)) || group.isAvailable(this.data);
        this.field_146292_n.clear();
        if (!taken && available && this.data.getLevelPoints() > 0) {
            this.field_146292_n.add(new GuiButtonLearn(this, this.left + this.xSize, this.top + this.ySize - 30));
        }
        int lines = (this.drawPieces.size() - 1) / 6 + 1;
        if (taken) {
            this.desc = TextHelper.renderText(this.left + 2, 0, 110, group.getUnlocalizedDesc(), false, false, new Object[0]);
            this.listText = new BigTextList(this.field_146297_k, 120, 168, this.top + 23, this.top + 174 - lines * 18, this.left + 130, 10, this.field_146294_l, this.field_146295_m);
        } else {
            this.listText = null;
        }
    }

    public void addToDrawList(Class<? extends SpellPiece> clazz) {
        if (clazz == null) {
            return;
        }
        SpellPiece piece = SpellPiece.create(clazz, this.spellWrapper);
        this.drawPieces.add(piece);
    }

    private class GroupList
    extends GuiScrollingList {
        public GroupList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
            super(client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
            this.func_27258_a(false);
        }

        protected int getSize() {
            return GuiLeveling.this.groups.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            GuiLeveling.this.selected = index;
            GuiLeveling.this.select(index);
        }

        protected boolean isSelected(int index) {
            return GuiLeveling.this.selected == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotId, int slotRight, int slotTop, int slotBuffer, Tessellator tess) {
            boolean taken;
            PieceGroup group = GuiLeveling.this.groups.get(slotId);
            if (slotId % 2 == 0) {
                Gui.func_73734_a((int)this.left, (int)slotTop, (int)(this.left + GuiLeveling.this.field_146294_l), (int)(slotTop + this.slotHeight), (int)0x1A000000);
            }
            if (this.isSelected(slotId)) {
                Gui.func_73734_a((int)this.left, (int)slotTop, (int)(this.left + GuiLeveling.this.field_146294_l), (int)(slotTop + this.slotHeight), (int)0x44005555);
            }
            boolean available = (taken = GuiLeveling.this.data.isPieceGroupUnlocked(group.name)) || group.isAvailable(GuiLeveling.this.data);
            int color = 0x777777;
            if (available) {
                color = 0xFFFFFF;
            }
            if (taken) {
                color = 0x77FF77;
            }
            GuiLeveling.this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)group.getUnlocalizedName()), this.left + 3, slotTop + 4, color);
            GuiLeveling.this.field_146297_k.field_71466_p.func_78276_b(String.format(I18n.func_74838_a((String)"psimisc.levelDisplay"), group.levelRequirement), this.left + 3, slotTop + 14, color);
        }

        protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        }
    }

    private class BigTextList
    extends GuiScrollingList {
        public BigTextList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
            super(client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
        }

        protected int getSize() {
            return GuiLeveling.this.desc.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            GuiLeveling.this.field_146297_k.field_71466_p.func_78276_b(GuiLeveling.this.desc.get(slotIdx), this.left + 4, slotTop, 0xFFFFFF);
        }

        protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        }
    }
}

