/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.Shard;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.ToolEvents;
import slimeknights.tconstruct.tools.TraitEvents;
import slimeknights.tconstruct.tools.common.RepairRecipe;
import slimeknights.tconstruct.tools.common.TableRecipe;
import slimeknights.tconstruct.tools.common.block.BlockToolForge;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.common.item.ItemBlockTable;
import slimeknights.tconstruct.tools.common.item.SharpeningKit;
import slimeknights.tconstruct.tools.common.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.common.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.common.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.common.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.common.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.common.tileentity.TileToolForge;
import slimeknights.tconstruct.tools.common.tileentity.TileToolStation;
import slimeknights.tconstruct.tools.ranged.item.BoltCore;

@Pulse(id="TinkerTools", description="All the tools and everything related to it.")
public class TinkerTools
extends AbstractToolPulse {
    public static final String PulseId = "TinkerTools";
    static final Logger log = Util.getLogger("TinkerTools");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ToolClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockToolTable toolTables;
    public static BlockToolForge toolForge;
    public static Pattern pattern;
    public static Shard shard;
    public static SharpeningKit sharpeningKit;
    public static ToolPart pickHead;
    public static ToolPart shovelHead;
    public static ToolPart axeHead;
    public static ToolPart broadAxeHead;
    public static ToolPart swordBlade;
    public static ToolPart largeSwordBlade;
    public static ToolPart hammerHead;
    public static ToolPart excavatorHead;
    public static ToolPart scytheHead;
    public static ToolPart panHead;
    public static ToolPart signHead;
    public static ToolPart toolRod;
    public static ToolPart toughToolRod;
    public static ToolPart binding;
    public static ToolPart toughBinding;
    public static ToolPart wideGuard;
    public static ToolPart handGuard;
    public static ToolPart crossGuard;
    public static ToolPart largePlate;
    public static ToolPart knifeBlade;
    public static ToolPart bowLimb;
    public static ToolPart bowString;
    public static ToolPart arrowHead;
    public static ToolPart arrowShaft;
    public static ToolPart fletching;
    public static BoltCore boltCore;

    @Override
    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        pattern = TinkerTools.registerItem(new Pattern(), "pattern");
        shard = TinkerTools.registerItem(new Shard(), "shard");
        sharpeningKit = (SharpeningKit)this.registerToolPart(new SharpeningKit(), "sharpening_kit");
        sharpeningKit.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        TinkerRegistry.registerToolPart(sharpeningKit);
        TinkerRegistry.registerToolPart(shard);
        super.preInit(event);
        toolTables = (BlockToolTable)TinkerTools.registerBlock((ItemBlock)new ItemBlockTable((Block)new BlockToolTable()), "tooltables");
        toolForge = (BlockToolForge)TinkerTools.registerBlock((ItemBlock)new ItemBlockTable((Block)new BlockToolForge()), "toolforge");
        ItemBlockMeta.setMappingProperty((Block)toolTables, BlockToolTable.TABLES);
        TinkerTools.registerTE(TileTable.class, "table");
        TinkerTools.registerTE(TileCraftingStation.class, "craftingstation");
        TinkerTools.registerTE(TileStencilTable.class, "stenciltable");
        TinkerTools.registerTE(TilePartBuilder.class, "partbuilder");
        TinkerTools.registerTE(TilePatternChest.class, "patternchest");
        TinkerTools.registerTE(TilePartChest.class, "partchest");
        TinkerTools.registerTE(TileToolStation.class, "toolstation");
        TinkerTools.registerTE(TileToolForge.class, "toolforge");
        EntityRegistry.registerModEntity(IndestructibleEntityItem.class, (String)"Indestructible Item", (int)0, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
        proxy.preInit();
        TinkerRegistry.setShardItem(shard);
        TinkerRegistry.registerStencilTableCrafting(Pattern.setTagForPart(new ItemStack((Item)pattern), sharpeningKit));
        TinkerRegistry.registerStencilTableCrafting(Pattern.setTagForPart(new ItemStack((Item)pattern), shard));
    }

    @Override
    protected void registerToolParts() {
        pickHead = this.registerToolPart(new ToolPart(288), "pick_head");
        shovelHead = this.registerToolPart(new ToolPart(288), "shovel_head");
        axeHead = this.registerToolPart(new ToolPart(288), "axe_head");
        broadAxeHead = this.registerToolPart(new ToolPart(1152), "broad_axe_head");
        swordBlade = this.registerToolPart(new ToolPart(288), "sword_blade");
        largeSwordBlade = this.registerToolPart(new ToolPart(1152), "large_sword_blade");
        hammerHead = this.registerToolPart(new ToolPart(1152), "hammer_head");
        excavatorHead = this.registerToolPart(new ToolPart(1152), "excavator_head");
        scytheHead = this.registerToolPart(new ToolPart(1152), "scythe_head");
        panHead = this.registerToolPart(new ToolPart(432), "pan_head");
        signHead = this.registerToolPart(new ToolPart(432), "sign_head");
        toolRod = this.registerToolPart(new ToolPart(144), "tool_rod");
        toughToolRod = this.registerToolPart(new ToolPart(432), "tough_tool_rod");
        binding = this.registerToolPart(new ToolPart(144), "binding");
        toughBinding = this.registerToolPart(new ToolPart(432), "tough_binding");
        wideGuard = this.registerToolPart(new ToolPart(144), "wide_guard");
        handGuard = this.registerToolPart(new ToolPart(144), "hand_guard");
        crossGuard = this.registerToolPart(new ToolPart(144), "cross_guard");
        largePlate = this.registerToolPart(new ToolPart(1152), "large_plate");
        knifeBlade = this.registerToolPart(new ToolPart(144), "knife_blade");
        bowLimb = this.registerToolPart(new ToolPart(432), "bow_limb");
        bowString = this.registerToolPart(new ToolPart(144), "bow_string");
        arrowHead = this.registerToolPart(new ToolPart(288), "arrow_head");
        arrowShaft = this.registerToolPart(new ToolPart(288), "arrow_shaft");
        fletching = this.registerToolPart(new ToolPart(288), "fletching");
        boltCore = (BoltCore)this.registerToolPart(new BoltCore(288), "bolt_core", null);
        toolparts.remove(boltCore);
    }

    @Override
    @Subscribe
    public void init(FMLInitializationEvent event) {
        super.init(event);
        proxy.init();
    }

    @Override
    protected void registerRecipies() {
        ItemStack pattern = new ItemStack((Item)TinkerTools.pattern, 4);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pattern, new Object[]{"PS", "SP", Character.valueOf('P'), "plankWood", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pattern, new Object[]{"SP", "PS", Character.valueOf('P'), "plankWood", Character.valueOf('S'), "stickWood"}));
        pattern.field_77994_a = 1;
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151122_aG), (Object[])new Object[]{Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151007_F, pattern, pattern});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new Object[]{"workbench"}));
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)"plankWood"), toolTables, BlockToolTable.TableTypes.StencilTable.meta, "P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "plankWood"));
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, (Block)TinkerCommons.blockFirewood, TinkerCommons.lavawood.func_77960_j()), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), TinkerCommons.lavawood});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, Blocks.field_150448_aq, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150448_aq});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, Blocks.field_150440_ba, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150440_ba});
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)"logWood"), toolTables, BlockToolTable.TableTypes.PartBuilder.meta, "P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "logWood"));
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, (Block)TinkerCommons.blockFirewood, TinkerCommons.firewood.func_77960_j()), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), TinkerCommons.firewood});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, Blocks.field_150318_D, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150318_D});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, (Block)Blocks.field_150434_aF, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150434_aF});
        ItemStack patternChest = new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.PatternChest.meta);
        ItemStack partChest = new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.PartChest.meta);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(patternChest, new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "chestWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(patternChest, new Object[]{"BBB", "BPB", "BBB", Character.valueOf('P'), pattern, Character.valueOf('B'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(partChest, new Object[]{" P ", "SCS", " B ", Character.valueOf('C'), "chestWood", Character.valueOf('S'), "stickWood", Character.valueOf('B'), "plankWood", Character.valueOf('P'), pattern}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.ToolStation.meta), new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "workbench"}));
        ItemStack slimeBallBlue = TinkerCommons.matSlimeBallBlue;
        ItemStack slimeBallPurple = TinkerCommons.matSlimeBallPurple;
        ItemStack slimeBallMagma = TinkerCommons.matSlimeBallMagma;
        ItemStack knightSlime = TinkerCommons.ingotKnightSlime;
        if (!TinkerTools.isWorldLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallBlue, new Object[]{Items.field_151123_aH, "dyeBlue"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallPurple, new Object[]{Items.field_151123_aH, "dyePurple"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallMagma, new Object[]{Items.field_151123_aH, "dyeOrange"}));
        }
        if (!TinkerTools.isSmelteryLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(knightSlime, new Object[]{slimeBallPurple, "ingotIron", "stone"}));
            if (!TinkerTools.isWorldLoaded()) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(knightSlime, new Object[]{Items.field_151123_aH, "dyePurple", "ingotIron", "stone"}));
            }
            GameRegistry.addSmelting((ItemStack)TinkerCommons.oreArdite, (ItemStack)TinkerCommons.ingotArdite, (float)1.0f);
            GameRegistry.addSmelting((ItemStack)TinkerCommons.oreCobalt, (ItemStack)TinkerCommons.ingotCobalt, (float)1.0f);
            GameRegistry.addShapelessRecipe((ItemStack)TinkerCommons.ingotManyullyn, (Object[])new Object[]{TinkerCommons.ingotCobalt, TinkerCommons.ingotArdite, Blocks.field_150402_ci});
            GameRegistry.addShapelessRecipe((ItemStack)TinkerCommons.nuggetManyullyn, (Object[])new Object[]{TinkerCommons.nuggetCobalt, TinkerCommons.nuggetArdite, Items.field_151044_h});
            ItemStack pigiron = TinkerCommons.ingotPigIron.func_77946_l();
            pigiron.field_77994_a = 3;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(pigiron, new Object[]{"ingotIron", "ingotIron", "ingotIron", Items.field_151147_al, Items.field_151147_al, Items.field_151147_al, "gemEmerald"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matExpanderW, new Object[]{" L ", "PSP", " L ", Character.valueOf('L'), "gemLapis", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), slimeBallPurple}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matExpanderH, new Object[]{" P ", "LSL", " P ", Character.valueOf('L'), "gemLapis", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), slimeBallPurple}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matSilkyCloth, new Object[]{"CCC", "CGC", "CCC", Character.valueOf('C'), Items.field_151007_F, Character.valueOf('G'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matSilkyJewel, new Object[]{" C ", "CEC", " C ", Character.valueOf('C'), TinkerCommons.matSilkyCloth, Character.valueOf('E'), "gemEmerald"}));
        String goldThing = "ingotGold";
        if (TinkerSmeltery.cast != null) {
            goldThing = "cast";
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matReinforcement, new Object[]{"OOO", "OPO", "OOO", Character.valueOf('O'), "obsidian", Character.valueOf('P'), goldThing}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matMoss, new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "blockMossy"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudGreen, new Object[]{Items.field_151123_aH, Items.field_151123_aH, Items.field_151123_aH, Items.field_151123_aH, "sand", "dirt"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudBlue, new Object[]{slimeBallBlue, slimeBallBlue, slimeBallBlue, slimeBallBlue, "sand", "dirt"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudMagma, new Object[]{slimeBallMagma, Items.field_151064_bs, slimeBallMagma, Items.field_151064_bs, Blocks.field_150425_aM, Blocks.field_150424_aL}));
        ItemStack congealed = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 0, BlockSlime.SlimeType.GREEN.meta);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudGreen, new Object[]{congealed, "sand", "dirt"}));
        congealed = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 0, BlockSlime.SlimeType.BLUE.meta);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudBlue, new Object[]{congealed, "sand", "dirt"}));
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudGreen, TinkerCommons.matSlimeCrystalGreen, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudBlue, TinkerCommons.matSlimeCrystalBlue, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudMagma, TinkerCommons.matSlimeCrystalMagma, 0.0f);
        if (!TinkerTools.isSmelteryLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.lavawood, new Object[]{" B ", "BWB", " B ", Character.valueOf('B'), "plankWood", Character.valueOf('W'), Items.field_151129_at}));
        }
        CraftingManager.func_77594_a().func_180302_a((IRecipe)new RepairRecipe());
    }

    public static void registerToolForgeBlock(String oredict) {
        if (toolForge != null) {
            TinkerTools.toolForge.baseBlocks.add(oredict);
            TinkerTools.registerToolForgeRecipe(oredict);
        }
    }

    private static void registerToolForgeRecipe(String oredict) {
        BlockSeared brick = TinkerSmeltery.searedBlock;
        if (brick == null) {
            brick = Blocks.field_150417_aV;
        }
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)oredict), toolForge, 0, new Object[]{"BBB", "MTM", "M M", Character.valueOf('B'), brick, Character.valueOf('M'), oredict, Character.valueOf('T'), new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.ToolStation.meta)}));
    }

    @Override
    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        proxy.postInit();
    }

    @Override
    protected void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)IndestructibleEntityItem.EventHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new TraitEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ToolEvents());
        MinecraftForge.EVENT_BUS.register((Object)DualToolHarvestUtils.INSTANCE);
    }
}

