/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.ranged;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.tools.ranged.IProjectile;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.traits.TraitEnderference;

public abstract class ProjectileCore
extends TinkerToolCore
implements IProjectile,
IAmmo {
    public static final String DAMAGE_TYPE_PROJECTILE = "arrow";
    protected int durabilityPerAmmo = 10;

    public ProjectileCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
    }

    protected void setDurabilityPerAmmo(int durabilityPerAmmo) {
        this.durabilityPerAmmo = durabilityPerAmmo;
    }

    public int getDurabilityPerAmmo() {
        return this.durabilityPerAmmo;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(this.getMaxAmmo(stack) - this.getCurrentAmmo(stack)) / (double)this.getMaxAmmo(stack);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getMaxAmmo(stack) != this.getCurrentAmmo(stack) && super.showDurabilityBar(stack);
    }

    @Override
    public int getCurrentAmmo(ItemStack stack) {
        return ToolHelper.getCurrentDurability(stack) / this.durabilityPerAmmo;
    }

    @Override
    public int getMaxAmmo(ItemStack stack) {
        return ToolHelper.getMaxDurability(stack) / this.durabilityPerAmmo;
    }

    @Override
    public void setAmmo(int count, ItemStack stack) {
        stack.func_77964_b(count * this.durabilityPerAmmo);
    }

    @Override
    public boolean addAmmo(ItemStack stack, EntityLivingBase player) {
        int ammo = this.getCurrentAmmo(stack);
        if (ammo < this.getMaxAmmo(stack)) {
            ToolHelper.healTool(stack, this.durabilityPerAmmo, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean useAmmo(ItemStack stack, @Nullable EntityLivingBase player) {
        int ammo = this.getCurrentAmmo(stack);
        if (ammo > 0) {
            ToolHelper.damageTool(stack, this.durabilityPerAmmo, player);
            int newAmmo = this.getCurrentAmmo(stack);
            if (newAmmo <= 0) {
                ToolHelper.breakTool(stack, player);
            }
            return newAmmo < ammo;
        }
        return false;
    }

    protected ItemStack getProjectileStack(ItemStack itemStack, World world, EntityPlayer player, boolean usedAmmo) {
        ItemStack reference = itemStack.func_77946_l();
        reference.field_77994_a = 1;
        this.setAmmo(1, reference);
        if (!(player.field_71075_bZ.field_75098_d || world.field_72995_K || usedAmmo)) {
            reference.field_77994_a = 0;
            this.setAmmo(0, reference);
        }
        ToolHelper.unbreakTool(reference);
        return reference;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Override
    public double attackSpeed() {
        return 100.0;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return false;
    }

    @Override
    public boolean dealDamageRanged(ItemStack stack, Entity projectile, EntityLivingBase player, Entity entity, float damage) {
        Object damageSource = new EntityDamageSourceIndirect(DAMAGE_TYPE_PROJECTILE, projectile, (Entity)player).func_76349_b();
        if (entity instanceof EntityEnderman && ((EntityEnderman)entity).func_70660_b((Potion)TraitEnderference.Enderference) != null) {
            damageSource = new DamageSourceProjectileForEndermen(DAMAGE_TYPE_PROJECTILE, projectile, (Entity)player);
        }
        return entity.func_70097_a(damageSource, damage);
    }

    @Override
    protected String getBrokenTooltip(ItemStack itemStack) {
        return Util.translate("tooltip.tool.empty", new Object[0]);
    }

    @Override
    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addAmmo(!detailed);
        info.addAttack();
        info.addAccuracy();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        return this.func_111205_h(slot);
    }

    @Override
    public Multimap<String, AttributeModifier> getProjectileAttributeModifier(ItemStack stack) {
        return super.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
    }

    @Override
    public abstract ProjectileNBT buildTagData(List<Material> var1);

    public static class DamageSourceProjectileForEndermen
    extends EntityDamageSource {
        public final Entity field_76382_s;

        public DamageSourceProjectileForEndermen(String damageTypeIn, Entity projectile, Entity damageSourceEntityIn) {
            super(damageTypeIn, damageSourceEntityIn);
            this.field_76382_s = projectile;
        }

        @Nullable
        public Entity func_76364_f() {
            return this.field_76382_s;
        }
    }
}

