/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.texture.AnimatedColoredTexture;
import slimeknights.tconstruct.library.client.texture.InverseColoredTexture;
import slimeknights.tconstruct.library.client.texture.MetalColoredTexture;
import slimeknights.tconstruct.library.client.texture.MetalTextureTexture;
import slimeknights.tconstruct.library.client.texture.SimpleColoredTexture;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

@SideOnly(value=Side.CLIENT)
public interface MaterialRenderInfo {
    public TextureAtlasSprite getTexture(TextureAtlasSprite var1, String var2);

    public boolean isStitched();

    public boolean useVertexColoring();

    public int getVertexColor();

    public String getTextureSuffix();

    public MaterialRenderInfo setTextureSuffix(String var1);

    public static class AnimatedTexture
    extends AbstractMaterialRenderInfo {
        protected String texturePath;

        public AnimatedTexture(String texturePath) {
            this.texturePath = texturePath;
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            TextureAtlasSprite blockTexture = Minecraft.func_71410_x().func_147117_R().getTextureExtry(this.texturePath);
            if (blockTexture == null) {
                blockTexture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            AnimatedColoredTexture sprite = new AnimatedColoredTexture(blockTexture, baseTexture, location);
            return sprite;
        }
    }

    public static class BlockTexture
    extends AbstractMaterialRenderInfo {
        protected String texturePath;

        public BlockTexture(String texturePath) {
            this.texturePath = texturePath;
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            TextureAtlasSprite blockTexture = Minecraft.func_71410_x().func_147117_R().getTextureExtry(this.texturePath);
            if (blockTexture == null) {
                blockTexture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            TextureColoredTexture sprite = new TextureColoredTexture(blockTexture, baseTexture, location);
            sprite.stencil = false;
            return sprite;
        }
    }

    public static class MetalTextured
    extends Metal {
        protected String extraTexture;

        public MetalTextured(String extraTexture, int color, float shinyness, float brightness, float hueshift) {
            super(color, shinyness, brightness, hueshift);
            this.extraTexture = extraTexture;
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            return new MetalTextureTexture(this.extraTexture, baseTexture, location, this.color, this.shinyness, this.brightness, this.hueshift);
        }
    }

    public static class Metal
    extends AbstractMaterialRenderInfo {
        protected float shinyness;
        protected float brightness;
        protected float hueshift;
        public int color;

        public Metal(int color, float shinyness, float brightness, float hueshift) {
            this.color = color;
            this.shinyness = shinyness;
            this.brightness = brightness;
            this.hueshift = hueshift;
        }

        public Metal(int color) {
            this(color, 0.4f, 0.4f, 0.1f);
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            return new MetalColoredTexture(baseTexture, location, this.color, this.shinyness, this.brightness, this.hueshift);
        }
    }

    public static class InverseMultiColor
    extends MultiColor {
        public InverseMultiColor(int low, int mid, int high) {
            super(low, mid, high);
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            return new InverseColoredTexture(this.low, this.mid, this.high, baseTexture, location);
        }
    }

    public static class MultiColor
    extends AbstractMaterialRenderInfo {
        protected final int low;
        protected final int mid;
        protected final int high;

        public MultiColor(int low, int mid, int high) {
            this.low = low;
            this.mid = mid;
            this.high = high;
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            return new SimpleColoredTexture(this.low, this.mid, this.high, baseTexture, location);
        }
    }

    public static class Default
    extends AbstractMaterialRenderInfo {
        public final int color;

        public Default(int color) {
            this.color = color;
        }

        @Override
        public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
            return baseTexture;
        }

        @Override
        public boolean isStitched() {
            return false;
        }

        @Override
        public boolean useVertexColoring() {
            return true;
        }

        @Override
        public int getVertexColor() {
            return this.color;
        }
    }

    public static abstract class AbstractMaterialRenderInfo
    implements MaterialRenderInfo {
        private String suffix;

        @Override
        public boolean isStitched() {
            return true;
        }

        @Override
        public boolean useVertexColoring() {
            return false;
        }

        @Override
        public int getVertexColor() {
            return -1;
        }

        @Override
        public String getTextureSuffix() {
            return this.suffix;
        }

        @Override
        public MaterialRenderInfo setTextureSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }
    }
}

