/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")
public class TileEntityRedstoneObserver
extends TileEntityBase
implements SimpleComponent {
    public static Set<TileEntityRedstoneObserver> loadedObservers = Collections.newSetFromMap(new WeakHashMap());
    BlockPos target;
    HashMap<EnumFacing, Integer> weakPower;
    HashMap<EnumFacing, Integer> strongPower;
    static Set<TileEntityRedstoneObserver> observerSet = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntityRedstoneObserver() {
        Set<TileEntityRedstoneObserver> set = loadedObservers;
        synchronized (set) {
            loadedObservers.add(this);
        }
        this.weakPower = new HashMap();
        this.strongPower = new HashMap();
        this.updateRedstoneState();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        if (this.target != null) {
            compound.func_74768_a("targetX", this.target.func_177958_n());
            compound.func_74768_a("targetY", this.target.func_177956_o());
            compound.func_74768_a("targetZ", this.target.func_177952_p());
        }
        NBTTagCompound weakPowerCompound = new NBTTagCompound();
        NBTTagCompound strongPowerCompound = new NBTTagCompound();
        for (EnumFacing facing : EnumFacing.values()) {
            weakPowerCompound.func_74768_a(facing.ordinal() + "", this.weakPower.get(facing).intValue());
            strongPowerCompound.func_74768_a(facing.ordinal() + "", this.strongPower.get(facing).intValue());
        }
        compound.func_74782_a("weakPowerCompound", (NBTBase)weakPowerCompound);
        compound.func_74782_a("strongPowerCompound", (NBTBase)strongPowerCompound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("targetX")) {
            this.target = new BlockPos(compound.func_74762_e("targetX"), compound.func_74762_e("targetY"), compound.func_74762_e("targetZ"));
        }
        NBTTagCompound weakPowerCompound = compound.func_74775_l("weakPowerCompound");
        NBTTagCompound strongPowerCompound = compound.func_74775_l("strongPowerCompound");
        for (EnumFacing facing : EnumFacing.values()) {
            this.weakPower.put(facing, weakPowerCompound.func_74762_e(facing.ordinal() + ""));
            this.strongPower.put(facing, strongPowerCompound.func_74762_e(facing.ordinal() + ""));
        }
    }

    public void setTarget(BlockPos newTarget) {
        if (!newTarget.equals((Object)this.target)) {
            this.target = newTarget;
            this.updateRedstoneState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyNeighbor(BlockEvent.NeighborNotifyEvent event) {
        Set<TileEntityRedstoneObserver> set = loadedObservers;
        synchronized (set) {
            for (TileEntityRedstoneObserver observer : loadedObservers) {
                if (observer.func_145831_w() != event.getWorld() || observer.func_145837_r() || observer.getTarget() == null || !observer.getTarget().equals((Object)event.getPos())) continue;
                observer.updateRedstoneState();
            }
        }
    }

    private void updateRedstoneState() {
        if (observerSet.contains((Object)this)) {
            return;
        }
        observerSet.add(this);
        if (this.target == null) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.strongPower.put(facing, 0);
            }
            for (EnumFacing facing : EnumFacing.values()) {
                this.weakPower.put(facing, 0);
            }
        } else {
            IBlockState targetState = this.field_145850_b.func_180495_p(this.target);
            for (EnumFacing facing : EnumFacing.values()) {
                this.strongPower.put(facing, targetState.func_185893_b((IBlockAccess)this.field_145850_b, this.target, facing));
                this.weakPower.put(facing, targetState.func_185911_a((IBlockAccess)this.field_145850_b, this.target, facing));
            }
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.redstoneObserver);
        }
        observerSet.remove((Object)this);
    }

    public void broken() {
        this.func_145843_s();
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.weakPower.get(side);
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.strongPower.get(side);
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "redstoneObserver";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setTarget(Context context, Arguments args) {
        this.setTarget(new BlockPos(args.checkInteger(0), args.checkInteger(1), args.checkInteger(2)));
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getTarget(Context context, Arguments args) {
        if (this.target == null) {
            return new Object[0];
        }
        return new Object[]{this.target.func_177958_n(), this.target.func_177956_o(), this.target.func_177952_p()};
    }
}

