/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.lib.properties.UnlistedBool;
import lumien.randomthings.tileentity.TileEntityFluidDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidDisplay
extends BlockContainerBase {
    public static final FluidProperty FLUID = new FluidProperty();
    public static final UnlistedBool FLOWING = UnlistedBool.create("flowing");

    public BlockFluidDisplay() {
        super("fluidDisplay", Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityFluidDisplay te = (TileEntityFluidDisplay)worldIn.func_175625_s(pos);
        if (heldItem != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem);
            if (liquid != null) {
                if (!worldIn.field_72995_K) {
                    te.setFluidName(liquid.getFluid().getName());
                    te.syncTE();
                }
                return true;
            }
        } else {
            if (!worldIn.field_72995_K) {
                te.toggleFlowing();
            }
            return true;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{FLOWING, FLUID});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityFluidDisplay te = (TileEntityFluidDisplay)worldIn.func_175625_s(pos);
        IExtendedBlockState actualState = (IExtendedBlockState)state;
        if (te == null) {
            return actualState.withProperty((IUnlistedProperty)FLUID, null).withProperty((IUnlistedProperty)FLOWING, (Object)false);
        }
        return actualState.withProperty((IUnlistedProperty)FLUID, (Object)te.getFluid()).withProperty((IUnlistedProperty)FLOWING, (Object)te.flowing());
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidDisplay();
    }

    private static class FluidProperty
    implements IUnlistedProperty<String> {
        private FluidProperty() {
        }

        public String getName() {
            return "fluid";
        }

        public boolean isValid(String value) {
            return true;
        }

        public Class<String> getType() {
            return String.class;
        }

        public String valueToString(String value) {
            return value;
        }
    }
}

