/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.shadowfacts.mirror.Mirror;
import net.shadowfacts.mirror.MirrorClass;
import net.shadowfacts.mirror.MirrorField;
import net.shadowfacts.mirror.stream.FieldStream;
import net.shadowfacts.shadowlib.util.Pair;
import net.shadowfacts.shadowmc.util.Vector3d;

public abstract class PacketBase<REQ extends PacketBase, REPLY extends IMessage>
implements IMessage,
IMessageHandler<REQ, REPLY> {
    private static Map<MirrorClass<?>, Pair<Reader, Writer>> handlers = new HashMap();

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        try {
            ((FieldStream)Mirror.of(this.getClass()).declaredFields().filter(PacketBase::accepts)).forEach((Consumer<? super MirrorField>)((Consumer<MirrorField>)f -> this.read((MirrorField)f, packetBuf)));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read packet " + this.getClass().getName(), e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        try {
            ((FieldStream)Mirror.of(this.getClass()).declaredFields().filter(PacketBase::accepts)).forEach((Consumer<? super MirrorField>)((Consumer<MirrorField>)f -> this.write((MirrorField)f, packetBuf)));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't write packet " + this.getClass().getName(), e);
        }
    }

    private void read(MirrorField f, PacketBuffer buf) {
        f.setAccessible(true);
        f.set(this, PacketBase.getHandlers(f).getLeft().read(buf));
    }

    private void write(MirrorField f, PacketBuffer buf) {
        f.setAccessible(true);
        PacketBase.getHandlers(f).getRight().write(f.get(this), buf);
    }

    private static boolean accepts(MirrorField f) {
        return !f.isFinal() && !f.isStatic() && !f.hasModifier(128) && handlers.containsKey(f.type());
    }

    public static Pair<Reader, Writer> getHandlers(MirrorField f) {
        return PacketBase.getHandlers(f.type());
    }

    public static Pair<Reader, Writer> getHandlers(MirrorClass<?> type) {
        return handlers.get(type);
    }

    public static <T> void addHandlers(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(Mirror.of(type), new Pair<Reader<T>, Writer<T>>(reader, writer));
    }

    static {
        PacketBase.addHandlers(Byte.TYPE, PacketBuffer::readByte, (b, buf) -> buf.writeByte((int)b.byteValue()));
        PacketBase.addHandlers(Short.TYPE, PacketBuffer::readShort, (s, buf) -> buf.writeShort((int)s.shortValue()));
        PacketBase.addHandlers(Integer.TYPE, PacketBuffer::readInt, (i, buf) -> buf.writeInt(i.intValue()));
        PacketBase.addHandlers(Long.TYPE, PacketBuffer::readLong, (l, buf) -> buf.writeLong(l.longValue()));
        PacketBase.addHandlers(Float.TYPE, PacketBuffer::readFloat, (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBase.addHandlers(Boolean.TYPE, PacketBuffer::readBoolean, (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBase.addHandlers(Character.TYPE, PacketBuffer::readChar, (c, buf) -> buf.writeChar((int)c.charValue()));
        PacketBase.addHandlers(String.class, ByteBufUtils::readUTF8String, (s, buf) -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        PacketBase.addHandlers(NBTTagCompound.class, ByteBufUtils::readTag, (tag, buf) -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag));
        PacketBase.addHandlers(ItemStack.class, ByteBufUtils::readItemStack, (stack, buf) -> ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack));
        PacketBase.addHandlers(BlockPos.class, PacketBuffer::func_179259_c, (pos, buf) -> buf.func_179255_a(pos));
        PacketBase.addHandlers(ITextComponent.class, buf -> {
            try {
                return buf.func_179258_d();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (component, buf) -> buf.func_179256_a(component));
        PacketBase.addHandlers(Vector3d.class, buf -> new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), (vec, buf) -> {
            buf.writeDouble(vec.x);
            buf.writeDouble(vec.y);
            buf.writeDouble(vec.z);
        });
        PacketBase.addHandlers(UUID.class, buf -> new UUID(buf.readLong(), buf.readLong()), (val, buf) -> {
            buf.writeLong(val.getMostSignificantBits());
            buf.writeLong(val.getLeastSignificantBits());
        });
        PacketBase.addHandlers(EnumHand.class, buf -> buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND, (val, buf) -> buf.writeBoolean(val == EnumHand.MAIN_HAND));
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public void write(T var1, PacketBuffer var2);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public T read(PacketBuffer var1);
    }
}

