/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.variations.vanilla.behaviour;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.utility.Logger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FollowAutoCraftItems
extends BehaviourBase<FollowAutoCraftItems> {
    private long lastExecutionTime;
    private int eatingItemTimer;
    private int poopingItemTimer;
    private EntityItem targetedItem;
    private long autocraftChangeTime;
    private ItemStack[] itemsToCollect = new ItemStack[9];
    private ItemStack[] itemsConsumed = new ItemStack[9];
    private ItemStack[] originalCraftingGrid = new ItemStack[9];

    public FollowAutoCraftItems(EntitySheep entity) {
        super(entity);
    }

    @Override
    public void updateTask() {
        EntitySheep entity = this.getEntity();
        World worldObj = entity.field_70170_p;
        if (this.eatingItemTimer > 0) {
            entity.func_70661_as().func_75499_g();
            this.eatingItemTimer = Math.max(0, this.eatingItemTimer - 1);
            if (this.eatingItemTimer == 4) {
                Logger.trace("Consuming Item", new Object[0]);
                this.consumeItem(worldObj);
            }
            return;
        }
        BlockPos position = entity.func_180425_c();
        if (this.poopingItemTimer > 0) {
            entity.func_70661_as().func_75499_g();
            this.poopingItemTimer = Math.max(0, this.poopingItemTimer - 1);
            if (this.poopingItemTimer == 1) {
                Logger.trace("Crafting Item", new Object[0]);
                this.createItem(entity, worldObj);
                this.lastExecutionTime = worldObj.func_82737_E();
            }
            return;
        }
        if (this.lastExecutionTime + 20L < worldObj.func_82737_E()) {
            this.lastExecutionTime = worldObj.func_82737_E();
            if (this.findItemToConsume(entity, worldObj, position)) {
                return;
            }
            Logger.trace("No items found", new Object[0]);
        }
    }

    private boolean findItemToConsume(EntitySheep entity, World worldObj, BlockPos position) {
        long lastChanged;
        IChiseledSheepCapability capability = (IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null);
        NBTTagCompound extraData = capability.getExtraData();
        if (!extraData.func_74764_b("AUTO_CRAFT")) {
            return true;
        }
        NBTTagCompound craftMatrixNBT = extraData.func_74775_l("AUTO_CRAFT");
        if (craftMatrixNBT.func_74764_b("lastChanged")) {
            lastChanged = craftMatrixNBT.func_74763_f("lastChanged");
            if (lastChanged != this.autocraftChangeTime) {
                this.updateItemsConsumed();
                this.reloadAutoCraftProperties(craftMatrixNBT);
            }
        } else {
            return true;
        }
        this.autocraftChangeTime = lastChanged;
        Logger.trace("Checking surroundings for items", new Object[0]);
        AxisAlignedBB offset = new AxisAlignedBB(position).func_72314_b(16.0, 16.0, 16.0).func_72317_d(-8.0, -8.0, -8.0);
        List recipeItems = worldObj.func_175674_a((Entity)entity, offset, e -> {
            if (e instanceof EntityItem) {
                if (e.field_70160_al) {
                    return false;
                }
                int age = ((EntityItem)e).field_70292_b;
                if (age > 0 && age < 40) {
                    return false;
                }
                ItemStack stack = ((EntityItem)e).func_92059_d();
                for (ItemStack itemStack : this.itemsToCollect) {
                    if (!FollowAutoCraftItems.areItemStacksEqual(stack, itemStack)) continue;
                    return true;
                }
            }
            return false;
        });
        recipeItems.sort((e, e2) -> Double.valueOf(e.func_70068_e((Entity)entity)).compareTo(e2.func_70068_e((Entity)entity)));
        for (Entity recipeItem : recipeItems) {
            double distanceSqToEntity = entity.func_70068_e(recipeItem);
            if (distanceSqToEntity < 0.75) {
                Logger.trace("Eating %s", recipeItem);
                this.eatingItemTimer = 40;
                worldObj.func_72960_a((Entity)entity, (byte)10);
                this.targetedItem = (EntityItem)recipeItem;
                entity.func_70661_as().func_75499_g();
                entity.func_70671_ap().func_75651_a(recipeItem, (float)entity.func_184649_cE(), (float)entity.func_70646_bf());
                return true;
            }
            if (!entity.func_70661_as().func_75497_a(recipeItem, 1.0)) continue;
            Logger.trace("Moving to %s", recipeItem);
            return true;
        }
        return false;
    }

    @Override
    public void onBehaviourStopped(BlockPos previousPos) {
        EntitySheep entity = this.getEntity();
        World entityWorld = entity.func_130014_f_();
        for (int i = 0; i < 9; ++i) {
            EntityItem entityItem;
            if (this.itemsConsumed[i] != null) {
                entityItem = new EntityItem(entityWorld, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.itemsConsumed[i]);
                entityItem.func_174869_p();
                entityWorld.func_72838_d((Entity)entityItem);
            }
            if (this.originalCraftingGrid[i] == null) continue;
            entityItem = new EntityItem(entityWorld, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.originalCraftingGrid[i]);
            entityItem.func_174869_p();
            entityWorld.func_72838_d((Entity)entityItem);
        }
        NBTTagCompound extraData = ((IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null)).getExtraData();
        extraData.func_82580_o("AUTO_CRAFT");
    }

    private void consumeItem(World worldObj) {
        if (this.targetedItem != null && this.targetedItem.func_70089_S()) {
            ItemStack entityItem = this.targetedItem.func_92059_d();
            while (entityItem.field_77994_a > 0 && this.consumeItem(entityItem)) {
                --entityItem.field_77994_a;
            }
            if (entityItem.field_77994_a == 0) {
                worldObj.func_72900_e((Entity)this.targetedItem);
            }
            Logger.trace("Add item to consumed", new Object[0]);
            this.updateItemsConsumed();
            this.checkDigested();
        }
    }

    private void checkDigested() {
        int itemsLeft = this.checkItemsLeftToConsume();
        if (itemsLeft == 0) {
            this.poopingItemTimer = 44;
            Logger.trace("Digesting Item", new Object[0]);
        } else {
            Logger.trace("%d items left", itemsLeft);
        }
    }

    private int checkItemsLeftToConsume() {
        int itemsLeft = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.itemsToCollect[i] == null) continue;
            ++itemsLeft;
        }
        return itemsLeft;
    }

    private void createItem(EntitySheep entity, World worldObj) {
        ContainerWorkbench container = new ContainerWorkbench(new InventoryPlayer(null), worldObj, entity.func_180425_c());
        for (int i = 0; i < 9; ++i) {
            container.field_75162_e.func_70299_a(i, this.itemsConsumed[i]);
        }
        CraftingManager instance = CraftingManager.func_77594_a();
        ItemStack craftedItem = instance.func_82787_a(container.field_75162_e, worldObj);
        if (craftedItem != null) {
            ItemStack[] remainingItems;
            EntityItem entityItem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, craftedItem);
            worldObj.func_72838_d((Entity)entityItem);
            entityItem.field_70177_z = entity.field_70761_aq + 180.0f;
            entityItem.func_70060_a(0.0f, 0.3f, 1.0f);
            for (ItemStack remainingItem : remainingItems = instance.func_180303_b(container.field_75162_e, worldObj)) {
                if (remainingItem == null) continue;
                entityItem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, remainingItem);
                worldObj.func_72838_d((Entity)entityItem);
                entityItem.field_70177_z = entity.field_70761_aq + 180.0f;
                entityItem.func_70060_a(0.0f, 0.3f, 1.0f);
            }
        }
        System.arraycopy(this.originalCraftingGrid, 0, this.itemsToCollect, 0, 9);
        this.itemsConsumed = new ItemStack[9];
        this.updateItemsConsumed();
    }

    private void updateItemsConsumed() {
        IChiseledSheepCapability capability = (IChiseledSheepCapability)this.getEntity().getCapability(Capability.CHISELED_SHEEP, null);
        NBTTagCompound extraData = capability.getExtraData();
        if (!extraData.func_74764_b("AUTO_CRAFT")) {
            return;
        }
        NBTTagCompound craftMatrixNBT = extraData.func_74775_l("AUTO_CRAFT");
        if (!craftMatrixNBT.func_74764_b("CONSUMED")) {
            craftMatrixNBT.func_74782_a("CONSUMED", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound consumed = craftMatrixNBT.func_74775_l("CONSUMED");
        for (int i = 0; i < 9; ++i) {
            if (this.itemsConsumed[i] == null) continue;
            String key = Integer.valueOf(i).toString();
            consumed.func_74782_a(key, (NBTBase)this.itemsConsumed[i].serializeNBT());
        }
    }

    private void reloadAutoCraftProperties(NBTTagCompound craftMatrixNBT) {
        if (!craftMatrixNBT.func_74764_b("CONSUMED")) {
            craftMatrixNBT.func_74782_a("CONSUMED", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound consumed = craftMatrixNBT.func_74775_l("CONSUMED");
        this.itemsToCollect = new ItemStack[9];
        this.originalCraftingGrid = new ItemStack[9];
        int itemCount = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack;
            String key = Integer.valueOf(i).toString();
            boolean nbtHasItemInIndex = craftMatrixNBT.func_74764_b(key);
            if (!nbtHasItemInIndex) continue;
            this.itemsToCollect[i] = itemstack = ItemStack.func_77949_a((NBTTagCompound)craftMatrixNBT.func_74775_l(key));
            this.originalCraftingGrid[i] = itemstack;
            ++itemCount;
        }
        Logger.trace("Looking for %d items", itemCount);
        EntitySheep entity = this.getEntity();
        World entityWorld = entity.func_130014_f_();
        this.itemsConsumed = new ItemStack[9];
        for (String key : consumed.func_150296_c()) {
            ItemStack consumedItemStack = ItemStack.func_77949_a((NBTTagCompound)consumed.func_74775_l(key));
            if (!this.consumeItem(consumedItemStack)) {
                EntityItem entityItem = new EntityItem(entityWorld, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, consumedItemStack);
                entityItem.func_174869_p();
                entityWorld.func_72838_d((Entity)entityItem);
                Logger.trace("Unable to consume %s", consumedItemStack);
                continue;
            }
            Logger.trace("Consumed %s", consumedItemStack);
        }
        this.checkDigested();
    }

    private boolean consumeItem(ItemStack consumedItemStack) {
        for (int i = 0; i < 9; ++i) {
            if (!FollowAutoCraftItems.areItemStacksEqual(consumedItemStack, this.itemsToCollect[i])) continue;
            this.itemsConsumed[i] = this.itemsToCollect[i];
            this.itemsToCollect[i] = null;
            return true;
        }
        return false;
    }

    private static boolean areItemStacksEqual(@Nullable ItemStack stackA, @Nullable ItemStack stackB) {
        return stackA == null && stackB == null ? true : (stackA != null && stackB != null ? FollowAutoCraftItems.isItemStackEqual(stackA, stackB) : false);
    }

    private static boolean isItemStackEqual(ItemStack thisa, ItemStack other) {
        if (thisa.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (thisa.func_77952_i() != other.func_77952_i()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)thisa, (ItemStack)other);
    }
}

