/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.variations.chancecubes;

import com.github.atomicblom.shearmadness.utility.Logger;

public class DelayedTask
implements Comparable<DelayedTask> {
    private final long expectedTick;
    private final Action task;

    public DelayedTask(long expectedTick, Action task) {
        this.expectedTick = expectedTick;
        this.task = task;
    }

    public void executeJob() {
        try {
            this.task.execute();
        }
        catch (Exception e) {
            Logger.warning("Failed to execute Delayed Task", e);
        }
    }

    public long getExpectedTick() {
        return this.expectedTick;
    }

    @Override
    public int compareTo(DelayedTask delayedTask) {
        if (delayedTask.expectedTick > this.expectedTick) {
            return -1;
        }
        if (delayedTask.expectedTick == this.expectedTick) {
            return 0;
        }
        return 1;
    }

    public static interface Action {
        public void execute();
    }
}

