/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.networking;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.networking.SheepChiseledMessage;
import com.github.atomicblom.shearmadness.utility.SoundLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SheepChiseledMessageHandler
implements IMessageHandler<SheepChiseledMessage, IMessage> {
    public static long lastSoundPlayed = 0L;

    public IMessage onMessage(SheepChiseledMessage message, MessageContext ctx) {
        int sheepId = message.getSheepId();
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(sheepId);
        if (entity == null) {
            return null;
        }
        IChiseledSheepCapability capability = (IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null);
        if (capability == null) {
            return null;
        }
        boolean chiseled = message.isChiseled();
        if (chiseled) {
            capability.chisel(message.getChiselItemStack());
            long totalWorldTime = entity.func_130014_f_().func_82737_E();
            if (lastSoundPlayed < totalWorldTime) {
                lastSoundPlayed = totalWorldTime;
                entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundLibrary.sheepchiseled, SoundCategory.NEUTRAL, 0.5f, 1.0f, true);
            }
        } else {
            capability.unChisel();
        }
        return null;
    }
}

