/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayCustomSoundMessage
implements IMessage {
    private double posX;
    private double posY;
    private double posZ;
    private ResourceLocation soundIn;
    private SoundCategory category;
    private float volume;
    private float pitch;
    private boolean distanceDelay;

    public PlayCustomSoundMessage() {
    }

    public PlayCustomSoundMessage(double posX, double posY, double posZ, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.soundIn = soundIn.getRegistryName();
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = distanceDelay;
    }

    public void fromBytes(ByteBuf byteBuf) {
        PacketBuffer buf = new PacketBuffer(byteBuf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.category = SoundCategory.values()[buf.readInt()];
        this.soundIn = new ResourceLocation(buf.func_150789_c(255));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.distanceDelay = buf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        PacketBuffer buf = new PacketBuffer(byteBuf);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.category.ordinal());
        buf.func_180714_a(this.soundIn.toString());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.distanceDelay);
    }

    @SideOnly(value=Side.CLIENT)
    public double getPosX() {
        return this.posX;
    }

    @SideOnly(value=Side.CLIENT)
    public double getPosY() {
        return this.posY;
    }

    @SideOnly(value=Side.CLIENT)
    public double getPosZ() {
        return this.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSoundEvent() {
        return this.soundIn;
    }

    @SideOnly(value=Side.CLIENT)
    public SoundCategory getCategory() {
        return this.category;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return this.volume;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDistanceDelay() {
        return this.distanceDelay;
    }
}

