/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.events;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.configuration.BreedingBehaviour;
import com.github.atomicblom.shearmadness.configuration.Settings;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public final class BreedingEventHandler {
    @SubscribeEvent
    public static void onBreedingEvent(BabyEntitySpawnEvent event) {
        if (Settings.Behaviours.getBreedingBehaviour() != BreedingBehaviour.SimpleBreeding) {
            return;
        }
        EntityLiving parentA = event.getParentA();
        EntityLiving parentB = event.getParentB();
        EntityAgeable child = event.getChild();
        if (!(child != null && parentA.hasCapability(Capability.CHISELED_SHEEP, null) && parentB.hasCapability(Capability.CHISELED_SHEEP, null) && child.hasCapability(Capability.CHISELED_SHEEP, null))) {
            return;
        }
        IChiseledSheepCapability parentACapability = (IChiseledSheepCapability)parentA.getCapability(Capability.CHISELED_SHEEP, null);
        IChiseledSheepCapability parentBCapability = (IChiseledSheepCapability)parentB.getCapability(Capability.CHISELED_SHEEP, null);
        IChiseledSheepCapability childCapability = (IChiseledSheepCapability)child.getCapability(Capability.CHISELED_SHEEP, null);
        ItemStack parentAItem = parentACapability.getChiselItemStack();
        ItemStack parentBItem = parentBCapability.getChiselItemStack();
        if (event.getParentA().field_70170_p.field_73012_v.nextDouble() >= 0.5) {
            if (parentACapability.isChiseled() && parentAItem != null) {
                childCapability.chisel(parentAItem);
            }
        } else if (parentBCapability.isChiseled() && parentBItem != null) {
            childCapability.chisel(parentBItem);
        }
    }
}

