/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.configuration;

import com.github.atomicblom.shearmadness.api.events.ShearMadnessSyncSettingsEvent;
import com.github.atomicblom.shearmadness.configuration.Settings;
import com.github.atomicblom.shearmadness.utility.Logger;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum ConfigurationHandler {
    INSTANCE;

    private static final String CONFIG_VERSION = "2";
    private File fileRef = null;
    private Configuration config = null;
    private Optional<Configuration> configOld = Optional.empty();

    public static void init(File configFile) {
        INSTANCE.setConfig(configFile);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public Configuration getConfig() {
        return this.config;
    }

    private void setConfig(File configFile) {
        Preconditions.checkState((this.config == null ? 1 : 0) != 0, (Object)"ConfigurationHandler has been initialized more than once.");
        this.fileRef = configFile;
        this.config = new Configuration(configFile, CONFIG_VERSION);
        if (!CONFIG_VERSION.equals(this.config.getLoadedConfigVersion())) {
            File fileBak = new File(this.fileRef.getAbsolutePath() + '_' + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".old");
            Logger.warning("Your %s config file is out of date and could cause issues. The existing file will be renamed to %s and a new one will be generated.", "Shear Madness", fileBak.getName());
            Logger.warning("%s will attempt to copy your old settings, but custom mod/tree settings will have to be migrated manually.", "Shear Madness");
            boolean success = this.fileRef.renameTo(fileBak);
            Logger.warning("Rename %s successful.", success ? "was" : "was not");
            this.configOld = Optional.of(this.config);
            this.config = new Configuration(this.fileRef, CONFIG_VERSION);
        }
        this.syncConfig(true);
    }

    void syncConfig() {
        this.syncConfig(false);
    }

    private void syncConfig(boolean skipLoad) {
        if (!skipLoad) {
            try {
                this.config.load();
            }
            catch (Exception e) {
                File fileBak = new File(this.fileRef.getAbsolutePath() + '_' + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".errored");
                Logger.severe("An exception occurred while loading your config file. This file will be renamed to %s and a new config file will be generated.", fileBak.getName());
                Logger.severe("Exception encountered: %s", e.getLocalizedMessage());
                boolean success = this.fileRef.renameTo(fileBak);
                Logger.warning("Rename %s successful.", success ? "was" : "was not");
                this.config = new Configuration(this.fileRef, CONFIG_VERSION);
            }
            this.convertOldConfig();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ShearMadnessSyncSettingsEvent(this.config));
        Settings.syncConfig(this.config);
        this.saveConfig();
    }

    private void saveConfig() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void convertOldConfig() {
        if (this.configOld.isPresent()) {
            Settings.syncConfig(this.config);
            this.configOld = Optional.empty();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("shearmadness")) {
            this.saveConfig();
            this.syncConfig();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("fileRef", (Object)this.fileRef).add("config", (Object)this.config).add("configOld", this.configOld).toString();
    }
}

