/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.behaviour;

import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DamageBehaviour
extends BehaviourBase<DamageBehaviour> {
    private final DamageSource damageSource;
    private AxisAlignedBB searchBox = null;

    public DamageBehaviour(EntitySheep sheep, Supplier<Boolean> configuration, DamageSource damageSource) {
        super(sheep, configuration);
        this.damageSource = damageSource;
    }

    @Override
    public void onBehaviourStarted(BlockPos currentPos) {
        this.onSheepMovedBlock(null, currentPos);
    }

    @Override
    public void onSheepMovedBlock(BlockPos previousLocation, BlockPos newLocation) {
        this.searchBox = new AxisAlignedBB(newLocation.func_177982_a(-2, -2, -2), newLocation.func_177982_a(2, 2, 2));
    }

    @Override
    public void updateTask() {
        EntitySheep entity = this.getEntity();
        for (Entity nearbyEntity : entity.field_70170_p.func_72839_b((Entity)entity, this.searchBox)) {
            double distance = entity.func_70068_e(nearbyEntity);
            if (!(distance < 1.2)) continue;
            if (nearbyEntity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)nearbyEntity;
                int wasInLove = animal.field_70881_d;
                if (nearbyEntity.func_70097_a(this.damageSource, 1.0f)) continue;
                animal.field_70881_d = wasInLove;
                continue;
            }
            nearbyEntity.func_70097_a(this.damageSource, 1.0f);
        }
    }

    @Override
    public boolean isEquivalentTo(DamageBehaviour other) {
        return super.isEquivalentTo(other) && Objects.equals(this.damageSource, other.damageSource);
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }
}

