/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.ai;

import com.github.atomicblom.shearmadness.api.BehaviourRegistry;
import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class SheepBehaviourAI
extends EntityAIBase {
    private final EntitySheep entity;
    private IChiseledSheepCapability capability = null;
    private int lastCheckedId = 0;
    private boolean hasActiveBehaviour = false;
    private BlockPos previousPos = null;
    private ActiveBehaviour[] activeBehaviours = new ActiveBehaviour[0];

    public SheepBehaviourAI(EntityLiving entity) {
        this.capability = (IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null);
        this.entity = entity instanceof EntitySheep ? (EntitySheep)entity : null;
    }

    public BehaviourBase getBehaviour(Class<? extends BehaviourBase> behaviour) {
        for (ActiveBehaviour activeBehaviour : this.activeBehaviours) {
            if (activeBehaviour.behaviour.getClass() != behaviour) continue;
            return activeBehaviour.behaviour;
        }
        return null;
    }

    public boolean func_75250_a() {
        if (this.capability == null || this.entity == null) {
            return false;
        }
        if (this.capability.getItemIdentifier() != this.lastCheckedId) {
            this.hasActiveBehaviour = false;
            ItemStack itemStack = this.capability.getChiselItemStack();
            ActiveBehaviour[] previousActiveBehaviours = this.activeBehaviours;
            ArrayList newActiveBehaviours = Lists.newArrayList();
            for (ActiveBehaviour activeBehaviour : previousActiveBehaviours) {
                activeBehaviour.matched = false;
            }
            if (itemStack != null) {
                for (BehaviourBase newBehaviour : BehaviourRegistry.INSTANCE.getApplicableBehaviours(itemStack, this.entity)) {
                    boolean matched = false;
                    for (ActiveBehaviour previousActiveBehaviour : previousActiveBehaviours) {
                        if (previousActiveBehaviour.behaviour.getClass() != newBehaviour.getClass() || !previousActiveBehaviour.behaviour.isEquivalentTo(newBehaviour)) continue;
                        newActiveBehaviours.add(previousActiveBehaviour);
                        previousActiveBehaviour.matched = true;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    newActiveBehaviours.add(new ActiveBehaviour(newBehaviour));
                }
            }
            for (ActiveBehaviour activeBehaviour : previousActiveBehaviours) {
                if (activeBehaviour.matched) continue;
                activeBehaviour.behaviour.onBehaviourStopped(this.previousPos);
            }
            this.activeBehaviours = new ActiveBehaviour[newActiveBehaviours.size()];
            this.activeBehaviours = newActiveBehaviours.toArray(this.activeBehaviours);
            this.lastCheckedId = this.capability.getItemIdentifier();
        }
        if (!this.capability.isChiseled()) {
            return false;
        }
        this.hasActiveBehaviour = false;
        for (ActiveBehaviour activeBehaviour : this.activeBehaviours) {
            boolean ranLastTick = activeBehaviour.runThisTick;
            activeBehaviour.runThisTick = false;
            if (activeBehaviour.behaviour.isBehaviourEnabled()) {
                this.hasActiveBehaviour = true;
                activeBehaviour.runThisTick = true;
                continue;
            }
            if (!ranLastTick) continue;
            activeBehaviour.behaviour.onBehaviourStopped(this.previousPos);
            activeBehaviour.isFirstTick = true;
        }
        return this.hasActiveBehaviour;
    }

    public void func_75246_d() {
        BlockPos currentPos = this.entity.func_180425_c();
        if (!currentPos.equals((Object)this.previousPos)) {
            for (ActiveBehaviour activeBehaviour : this.activeBehaviours) {
                if (!activeBehaviour.runThisTick || activeBehaviour.isFirstTick) continue;
                activeBehaviour.behaviour.onSheepMovedBlock(this.previousPos, currentPos);
            }
            this.previousPos = currentPos;
        }
        for (ActiveBehaviour activeBehaviour : this.activeBehaviours) {
            if (!activeBehaviour.runThisTick) continue;
            if (activeBehaviour.isFirstTick) {
                activeBehaviour.behaviour.onBehaviourStarted(currentPos);
                activeBehaviour.isFirstTick = false;
            }
            activeBehaviour.behaviour.updateTask();
        }
    }

    public void onDeath() {
        for (ActiveBehaviour activeBehaviour : this.activeBehaviours) {
            if (!activeBehaviour.runThisTick) continue;
            activeBehaviour.behaviour.onBehaviourStopped(this.previousPos);
        }
    }

    private class ActiveBehaviour {
        BehaviourBase behaviour;
        boolean runThisTick;
        boolean matched;
        boolean isFirstTick;

        ActiveBehaviour(BehaviourBase behaviour) {
            this.behaviour = behaviour;
            this.isFirstTick = true;
        }
    }
}

