/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.transformers;

import guichaguri.betterfps.transformers.annotations.Param;
import guichaguri.betterfps.tweaker.Mappings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtils {
    public static ClassNode readClass(byte[] bytes, int flags) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, flags);
        return classNode;
    }

    public static byte[] writeClass(ClassNode node, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static MethodNode findMethod(ClassNode node, Mappings mappings) {
        for (MethodNode m : node.methods) {
            if (!mappings.is(m.name, m.desc)) continue;
            return m;
        }
        return null;
    }

    public static FieldNode findField(ClassNode node, Mappings mappings) {
        for (FieldNode m : node.fields) {
            if (!mappings.is(m.name, m.desc)) continue;
            return m;
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode node, String name, String desc) {
        for (MethodNode m : node.methods) {
            if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
            return m;
        }
        return null;
    }

    public static FieldNode findField(ClassNode node, String name, String desc) {
        for (FieldNode f : node.fields) {
            if (!f.name.equals(name) || !f.desc.equals(desc)) continue;
            return f;
        }
        return null;
    }

    public static int getNextAvailableIndex(List<LocalVariableNode> nodes) {
        return ASMUtils.getNextAvailableIndex(nodes, 0);
    }

    private static int getNextAvailableIndex(List<LocalVariableNode> nodes, int index) {
        for (LocalVariableNode node : nodes) {
            if (index != node.index) continue;
            return ASMUtils.getNextAvailableIndex(nodes, node.index + 1);
        }
        return index;
    }

    public static boolean isReturn(int opcode) {
        return opcode == 177 || opcode == 176 || opcode == 175 || opcode == 174 || opcode == 172 || opcode == 173;
    }

    public static void appendNodeList(InsnList initial, InsnList extra) {
        List<AbstractInsnNode> returns = ASMUtils.findReturns(initial);
        for (AbstractInsnNode r2 : returns) {
            initial.insertBefore(r2, extra);
        }
    }

    public static void prependNodeList(InsnList initial, InsnList extra) {
        AbstractInsnNode head = ASMUtils.findHead(initial);
        initial.insert(head, extra);
    }

    public static void removeLastReturn(InsnList list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            AbstractInsnNode node = list.get(i);
            if (!ASMUtils.isReturn(node.getOpcode())) continue;
            list.remove(node);
            break;
        }
    }

    public static void setVariableToMaxPeriod(AbstractInsnNode[] nodes, LocalVariableNode node) {
        LabelNode first = null;
        LabelNode last = null;
        for (AbstractInsnNode n : nodes) {
            if (!(n instanceof LabelNode)) continue;
            last = (LabelNode)n;
            if (first != null) continue;
            first = last;
        }
        node.start = first;
        node.end = last;
    }

    public static AnnotationNode getAnnotation(List<AnnotationNode> annotations, Class<? extends Annotation> type) {
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        String t = Type.getDescriptor(type);
        for (AnnotationNode node : annotations) {
            if (!node.desc.equals(t)) continue;
            return node;
        }
        return null;
    }

    public static String getAnnotationValue(AnnotationNode node, String k) {
        return ASMUtils.getAnnotationValue(node, k, String.class);
    }

    public static <T> T getAnnotationValue(AnnotationNode node, String k, Class<T> type) {
        return ASMUtils.getAnnotationValue(node, k, type, null);
    }

    public static <T> T getAnnotationValue(AnnotationNode node, String k, Class<T> type, T def) {
        if (node.values == null) {
            return def;
        }
        boolean isEnum = type.isEnum();
        for (int x = 0; x < node.values.size() - 1; x += 2) {
            Object key = node.values.get(x);
            Object value = node.values.get(x + 1);
            if (!(key instanceof String) || !key.equals(k)) continue;
            if (isEnum) {
                if (!(value instanceof String[])) continue;
                return Enum.valueOf(type, ((String[])value)[1]);
            }
            if (value instanceof String[]) {
                return (T)((String[])value)[1];
            }
            return (T)value;
        }
        return def;
    }

    public static String getReturnDesc(String desc) {
        return Type.getReturnType((String)desc).getDescriptor();
    }

    public static String[] getParametersDesc(String desc) {
        Type[] t = Type.getArgumentTypes((String)desc);
        String[] r2 = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            r2[i] = t[i].getDescriptor();
        }
        return r2;
    }

    private static boolean isNode(AbstractInsnNode node, Class type, int opcode, String owner, String name, String desc) {
        if (opcode != -1 && node.getOpcode() != opcode) {
            return false;
        }
        if (node.getClass() != type) {
            return false;
        }
        if (type == MethodInsnNode.class) {
            MethodInsnNode method = (MethodInsnNode)node;
            if (owner != null && !method.owner.equals(owner)) {
                return false;
            }
            if (name != null && !method.name.equals(name)) {
                return false;
            }
            if (desc != null && !method.desc.equals(desc)) {
                return false;
            }
        } else if (type == FieldInsnNode.class) {
            FieldInsnNode field = (FieldInsnNode)node;
            if (owner != null && !field.owner.equals(owner)) {
                return false;
            }
            if (name != null && !field.name.equals(name)) {
                return false;
            }
            if (desc != null && !field.desc.equals(desc)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isNode(AbstractInsnNode node, Class type, int opcode, Mappings name) {
        if (node.getOpcode() != opcode || node.getClass() != type) {
            return false;
        }
        return !(type == MethodInsnNode.class ? !name.is((MethodInsnNode)node) : type == FieldInsnNode.class && !name.is((FieldInsnNode)node));
    }

    public static <T extends AbstractInsnNode> List<T> findNodes(InsnList nodes, Class<T> type, int opcode, String owner, String name, String desc) {
        ArrayList<AbstractInsnNode> list = null;
        for (int i = 0; i < nodes.size(); ++i) {
            AbstractInsnNode node = nodes.get(i);
            if (!ASMUtils.isNode(node, type, opcode, owner, name, desc)) continue;
            if (list == null) {
                list = new ArrayList<AbstractInsnNode>();
            }
            list.add(node);
        }
        return list;
    }

    public static <T extends AbstractInsnNode> List<T> findNodes(InsnList nodes, Class<T> type, int opcode) {
        return ASMUtils.findNodes(nodes, type, opcode, null, null, null);
    }

    public static <T extends AbstractInsnNode> T findNode(InsnList nodes, Class<T> type, int opcode, int index, String owner, String name, String desc) {
        for (int i = 0; i < nodes.size(); ++i) {
            AbstractInsnNode node = nodes.get(i);
            if (!ASMUtils.isNode(node, type, opcode, owner, name, desc) || index-- > 0) continue;
            return (T)node;
        }
        return null;
    }

    public static <T extends AbstractInsnNode> T findNode(InsnList nodes, Class<T> type, int opcode, int index, Mappings name) {
        for (int i = 0; i < nodes.size(); ++i) {
            AbstractInsnNode node = nodes.get(i);
            if (!ASMUtils.isNode(node, type, opcode, name) || index-- > 0) continue;
            return (T)node;
        }
        return null;
    }

    public static <T extends AbstractInsnNode> T findNode(InsnList nodes, Class<T> type, int opcode, int index) {
        return ASMUtils.findNode(nodes, type, opcode, index, null, null, null);
    }

    public static LocalVariableNode findVariable(MethodNode method, int index) {
        for (LocalVariableNode var : method.localVariables) {
            if (var.index != index) continue;
            return var;
        }
        return null;
    }

    public static LocalVariableNode findVariable(MethodNode method, Mappings mappings) {
        for (LocalVariableNode var : method.localVariables) {
            if (!mappings.is(Type.getType((String)var.desc).getClassName())) continue;
            return var;
        }
        return null;
    }

    public static int[] getLocalVariables(MethodNode method, ClassNode targetClass, MethodNode targetMethod) {
        int[] variables = new int[method.parameters.size()];
        List[] array = method.visibleParameterAnnotations;
        for (int i = 0; i < array.length; ++i) {
            Integer value;
            AnnotationNode annotation;
            List annotations = array[i];
            if (annotations == null || annotations.isEmpty() || (annotation = ASMUtils.getAnnotation(annotations, Param.class)) == null || (value = ASMUtils.getAnnotationValue(annotation, "value", Integer.class)) == null) continue;
            variables[i] = value;
        }
        return variables;
    }

    public static LocalVariableNode insertVariable(MethodNode m, String name, String desc, String sig, LabelNode l1, LabelNode l2) {
        LocalVariableNode var = new LocalVariableNode(name, desc, sig, l1, l2, m.maxLocals);
        m.localVariables.add(var);
        ++m.maxLocals;
        return var;
    }

    public static void removeLabelSection(InsnList list, LabelNode label) {
        ListIterator i = list.iterator(list.indexOf((AbstractInsnNode)label) + 1);
        AbstractInsnNode node = (AbstractInsnNode)i.next();
        while (i.hasNext() && !(node instanceof LabelNode)) {
            i.remove();
            node = (AbstractInsnNode)i.next();
        }
    }

    public static boolean isNodeInside(InsnList list, AbstractInsnNode node, LabelNode from, LabelNode to) {
        boolean inside = false;
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode n = list.get(i);
            if (n == from) {
                inside = true;
            } else if (n == to) {
                return false;
            }
            if (n != node) continue;
            return inside;
        }
        return false;
    }

    public static boolean hasAccess(MethodNode m, int access) {
        return (m.access & access) != 0;
    }

    public static boolean hasAccess(FieldNode f, int access) {
        return (f.access & access) != 0;
    }

    public static int indexOf(Type[] types, Type[] needle) {
        int count = 0;
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getDescriptor().equals(needle[count].getDescriptor())) {
                if (++count < needle.length) continue;
                return i - count;
            }
            count = 0;
        }
        return -1;
    }

    private static Object findVariable(MethodNode sourceMethod, ClassNode targetClass, MethodNode targetMethod, AbstractInsnNode pos, int i, String desc, boolean isStatic, int targetParamsStart, int targetParamsEnd) {
        AnnotationNode annotation;
        List[] annotations = sourceMethod.invisibleParameterAnnotations;
        if (annotations != null && annotations.length > i && (annotation = ASMUtils.getAnnotation(annotations[i], Param.class)) != null) {
            LocalVariableNode var;
            int index = ASMUtils.getAnnotationValue(annotation, "value", Integer.TYPE, -1);
            LocalVariableNode localVariableNode = var = index != -1 ? ASMUtils.findVariable(sourceMethod, index) : null;
            if (var != null && var.desc.equals(desc)) {
                return var;
            }
        }
        if (targetParamsStart != -1 && i >= targetParamsStart && i < targetParamsEnd) {
            return targetMethod.localVariables.get(i - targetParamsStart + (isStatic ? 0 : 1));
        }
        for (LocalVariableNode var : targetMethod.localVariables) {
            if (!var.desc.equals(desc) || !ASMUtils.isNodeInside(targetMethod.instructions, pos, var.start, var.end)) continue;
            return var;
        }
        for (FieldNode field : targetClass.fields) {
            if (isStatic && !ASMUtils.hasAccess(field, 8) || !field.desc.equals(desc)) continue;
            return field;
        }
        return null;
    }

    public static Object[] findParametersValue(MethodNode sourceMethod, ClassNode targetClass, MethodNode targetMethod, AbstractInsnNode pos) {
        Type[] parameters = Type.getArgumentTypes((String)sourceMethod.desc);
        Object[] values = new Object[parameters.length];
        Type[] targetParameters = Type.getArgumentTypes((String)targetMethod.desc);
        int targetParamsStart = ASMUtils.indexOf(parameters, targetParameters);
        int targetParamsEnd = targetParamsStart + targetParameters.length;
        boolean isStatic = ASMUtils.hasAccess(targetMethod, 8);
        for (int i = 0; i < parameters.length; ++i) {
            String d = parameters[i].getDescriptor();
            values[i] = ASMUtils.findVariable(sourceMethod, targetClass, targetMethod, pos, i, d, isStatic, targetParamsStart, targetParamsEnd);
        }
        return values;
    }

    public static AbstractInsnNode getReadNodeForVariable(ClassNode clazz, Object variable) {
        if (variable instanceof LocalVariableNode) {
            LocalVariableNode var = (LocalVariableNode)variable;
            return new VarInsnNode(Type.getType((String)var.desc).getOpcode(21), var.index);
        }
        if (variable instanceof FieldNode) {
            FieldNode field = (FieldNode)variable;
            return new FieldInsnNode(180, clazz.name, field.name, field.desc);
        }
        return new InsnNode(1);
    }

    public static AbstractInsnNode getWriteNodeForVariable(ClassNode clazz, Object variable) {
        if (variable instanceof LocalVariableNode) {
            LocalVariableNode var = (LocalVariableNode)variable;
            return new VarInsnNode(Type.getType((String)var.desc).getOpcode(54), var.index);
        }
        if (variable instanceof FieldNode) {
            FieldNode field = (FieldNode)variable;
            return new FieldInsnNode(181, clazz.name, field.name, field.desc);
        }
        return null;
    }

    public static InsnList insertMethod(ClassNode sourceClass, MethodNode sourceMethod, ClassNode targetClass, MethodNode targetMethod, AbstractInsnNode pos, boolean ignoreReturnValue) {
        Object[] parameters = ASMUtils.findParametersValue(sourceMethod, targetClass, targetMethod, pos);
        ASMUtils.copyMethod(sourceClass, targetClass, sourceMethod, true);
        boolean isStatic = ASMUtils.hasAccess(sourceMethod, 8);
        InsnList list = new InsnList();
        int stack = parameters.length;
        if (!isStatic) {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            ++stack;
        }
        for (Object o : parameters) {
            list.add(ASMUtils.getReadNodeForVariable(targetClass, o));
        }
        if (targetMethod.maxStack < stack) {
            targetMethod.maxStack = stack;
        }
        int opcode = isStatic ? 184 : 182;
        list.add((AbstractInsnNode)new MethodInsnNode(opcode, targetClass.name, sourceMethod.name, sourceMethod.desc, false));
        if (ignoreReturnValue && Type.getReturnType((String)sourceMethod.desc) != Type.VOID_TYPE) {
            list.add((AbstractInsnNode)new InsnNode(87));
        }
        return list;
    }

    public static AbstractInsnNode findHead(InsnList list) {
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode node = list.get(i);
            if (!(node instanceof LabelNode)) continue;
            return node;
        }
        return list.get(0);
    }

    public static List<AbstractInsnNode> findReturns(InsnList list) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode node = list.get(i);
            if (!ASMUtils.isReturn(node.getOpcode())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static void replaceReferences(String className, String replacement, MethodNode method) {
        String classNameDesc = String.format("L%s;", className);
        String replacementDesc = String.format("L%s;", replacement);
        method.desc = method.desc.replaceAll(classNameDesc, replacementDesc);
        InsnList list = method.instructions;
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode node = list.get(i);
            if (node instanceof MethodInsnNode) {
                MethodInsnNode m = (MethodInsnNode)node;
                m.desc = m.desc.replaceAll(classNameDesc, replacementDesc);
                if (!m.owner.equals(className)) continue;
                m.owner = replacement;
                continue;
            }
            if (node instanceof FieldInsnNode) {
                FieldInsnNode f = (FieldInsnNode)node;
                f.desc = f.desc.replaceAll(classNameDesc, replacementDesc);
                if (!f.owner.equals(className)) continue;
                f.owner = replacement;
                continue;
            }
            if (!(node instanceof TypeInsnNode)) continue;
            TypeInsnNode t = (TypeInsnNode)node;
            t.desc = t.desc.replaceAll(classNameDesc, replacementDesc);
        }
        for (LocalVariableNode var : method.localVariables) {
            if (!var.desc.equals(classNameDesc)) continue;
            var.desc = replacementDesc;
        }
    }

    public static void replaceReferences(String className, String replacement, FieldNode field) {
        field.desc = field.desc.replaceAll(className, replacement);
    }

    public static void replaceSuperCalls(MethodNode method, ClassNode replacedClass, MethodNode replacedMethod) {
        InsnList list = method.instructions;
        boolean addedReplacedMethod = false;
        boolean hasReplacedMethod = replacedMethod != null;
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode node = list.get(i);
            if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode m = (MethodInsnNode)node;
            if (!m.owner.equals(replacedClass.name) || hasReplacedMethod && (!m.name.equals(replacedMethod.name) || !m.desc.equals(replacedMethod.desc))) continue;
            if (!hasReplacedMethod) {
                if (!m.owner.equals(replacedClass.name)) continue;
                m.owner = replacedClass.superName;
                continue;
            }
            if (!addedReplacedMethod) {
                replacedMethod.name = replacedMethod.name + "_BetterFps";
                m.setOpcode(182);
                if (!replacedClass.methods.contains(replacedMethod)) {
                    replacedClass.methods.add(replacedMethod);
                }
                addedReplacedMethod = true;
            }
            m.name = replacedMethod.name;
        }
    }

    public static void mergeLocalVariables(MethodNode from, MethodNode to) {
        for (LocalVariableNode var : from.localVariables) {
            LocalVariableNode var2 = ASMUtils.findVariable(to, var.index);
            if (var2 == null) {
                to.localVariables.add(var);
                continue;
            }
            if (var2.desc.equals(var.desc)) continue;
            int oldIndex = var.index;
            var.index = to.maxLocals++;
            to.localVariables.add(var);
            InsnList list = from.instructions;
            for (int i = 0; i < list.size(); ++i) {
                AbstractInsnNode node = list.get(i);
                if (!(node instanceof VarInsnNode)) continue;
                VarInsnNode varNode = (VarInsnNode)node;
                if (varNode.var != oldIndex) continue;
                varNode.var = var.index;
            }
        }
    }

    public static void copyMethod(ClassNode original, ClassNode target, MethodNode method, boolean replace) {
        ASMUtils.copyMethod(original, target, method, ASMUtils.findMethod(target, method.name, method.desc), replace);
    }

    public static void copyMethod(ClassNode original, ClassNode target, MethodNode method, MethodNode replacedMethod, boolean replace) {
        if (replacedMethod != null) {
            if (!replace) {
                return;
            }
            target.methods.remove(replacedMethod);
        }
        ASMUtils.replaceSuperCalls(method, target, replacedMethod);
        ASMUtils.replaceReferences(original.name, target.name, method);
        target.methods.add(method);
    }

    public static void appendMethod(ClassNode original, ClassNode target, MethodNode method) {
        ASMUtils.appendMethod(original, target, method, ASMUtils.findMethod(target, method.name, method.desc));
    }

    public static void appendMethod(ClassNode original, ClassNode target, MethodNode method, MethodNode targetMethod) {
        if (targetMethod == null) {
            target.methods.add(method);
        } else {
            method.name = method.name + "_BetterFps";
            InsnList list = targetMethod.instructions;
            List<AbstractInsnNode> returns = ASMUtils.findReturns(list);
            for (AbstractInsnNode r2 : returns) {
                list.insertBefore(r2, ASMUtils.insertMethod(original, method, target, targetMethod, r2, true));
            }
        }
    }

    public static void prependMethod(ClassNode original, ClassNode target, MethodNode method) {
        ASMUtils.prependMethod(original, target, method, ASMUtils.findMethod(target, method.name, method.desc));
    }

    public static void prependMethod(ClassNode original, ClassNode target, MethodNode method, MethodNode targetMethod) {
        if (targetMethod == null) {
            target.methods.add(method);
        } else {
            method.name = method.name + "_BetterFps";
            InsnList list = targetMethod.instructions;
            AbstractInsnNode head = ASMUtils.findHead(list);
            list.insert(head, ASMUtils.insertMethod(original, method, target, targetMethod, head, true));
        }
    }

    public static void copyField(ClassNode original, ClassNode target, FieldNode field, boolean replace) {
        ASMUtils.copyField(original, target, field, ASMUtils.findField(target, field.name, field.desc), replace);
    }

    public static void copyField(ClassNode original, ClassNode target, FieldNode field, FieldNode replacedField, boolean replace) {
        if (replacedField != null) {
            if (!replace) {
                return;
            }
            target.fields.remove(replacedField);
        }
        ASMUtils.replaceReferences(original.name, target.name, field);
        target.fields.add(field);
    }
}

