/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.network;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.entity.block.BlockEntity;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEntityMessage
extends AbstractMessage<BlockEntityMessage> {
    private BlockPos pos;
    private NBTTagCompound compound;

    public BlockEntityMessage() {
    }

    public BlockEntityMessage(BlockEntity entity) {
        this.pos = entity.func_174877_v();
        this.compound = new NBTTagCompound();
        entity.saveTrackingSensitiveData(this.compound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, BlockEntityMessage message, EntityPlayer player, MessageContext messageContext) {
        BlockEntity blockEntity = (BlockEntity)player.field_70170_p.func_175625_s(message.pos);
        blockEntity.loadTrackingSensitiveData(message.compound);
    }

    @Override
    public void onServerReceived(MinecraftServer server, BlockEntityMessage message, EntityPlayer player, MessageContext messageContext) {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }
}

