/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<dr> {
    protected adz[] stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = new adz[size];
    }

    public ItemStackHandler(adz[] stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = new adz[size];
    }

    @Override
    public void setStackInSlot(int slot, adz stack) {
        this.validateSlotIndex(slot);
        if (adz.b((adz)this.stacks[slot], (adz)stack)) {
            return;
        }
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.length;
    }

    @Override
    public adz getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    @Override
    public adz insertItem(int slot, adz stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.b == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        adz existing = this.stacks[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.b;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.b > limit;
        if (!simulate) {
            if (existing == null) {
                this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack;
            } else {
                existing.b = existing.b + (reachedLimit ? limit : stack.b);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.b - limit) : null;
    }

    @Override
    public adz extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        adz existing = this.stacks[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.c());
        if (existing.b <= toExtract) {
            if (!simulate) {
                this.stacks[slot] = null;
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks[slot] = ItemHandlerHelper.copyStackWithSize(existing, existing.b - toExtract);
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    protected int getStackLimit(int slot, adz stack) {
        return stack.c();
    }

    @Override
    public dr serializeNBT() {
        dx nbtTagList = new dx();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            dr itemTag = new dr();
            itemTag.a("Slot", i);
            this.stacks[i].b(itemTag);
            nbtTagList.a((ef)itemTag);
        }
        dr nbt = new dr();
        nbt.a("Items", (ef)nbtTagList);
        nbt.a("Size", this.stacks.length);
        return nbt;
    }

    @Override
    public void deserializeNBT(dr nbt) {
        this.setSize(nbt.b("Size", 3) ? nbt.h("Size") : this.stacks.length);
        dx tagList = nbt.c("Items", 10);
        for (int i = 0; i < tagList.c(); ++i) {
            dr itemTags = tagList.b(i);
            int slot = itemTags.h("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = adz.a((dr)itemTags);
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.length + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

