/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableEnum<T extends Enum<T>>
extends SyncableObject {
    public T value;
    public T lastTickValue;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();

    public SyncableEnum(T value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.lastTickValue = value;
        this.value = this.lastTickValue;
        Enum[] v = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by SyncableEnum is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    public SyncableEnum(T value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.lastTickValue = value;
        this.value = this.lastTickValue;
        Enum[] v = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by SyncableEnum is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, (byte)this.valueToIndex.get(this.value).intValue(), this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, (byte)this.valueToIndex.get(this.value).intValue(), this.updateOnReceived), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 1) {
            this.value = (Enum)this.indexToValue.get(packet.byteValue & 0xFF);
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74774_a("SyncableEnum" + this.index, (byte)this.valueToIndex.get(this.value).intValue());
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableEnum" + this.index)) {
            this.value = (Enum)this.indexToValue.get(compound.func_74771_c("SyncableEnum" + this.index) & 0xFF);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

