/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableBoolArray
extends SyncableObject {
    private final int lenghth;
    private boolean[] boolCache;
    private byte[] bytes;
    private byte[] lastTickBytes;

    public SyncableBoolArray(boolean[] value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        int r = value.length % 8;
        this.lenghth = value.length + (r == 0 ? 0 : 8 - r);
        this.bytes = new byte[this.lenghth / 8];
        this.lastTickBytes = new byte[this.lenghth / 8];
        this.boolCache = new boolean[this.lenghth];
        if (value.length > 2048) {
            throw new IllegalArgumentException("BrandonsCore, SyncableBoolArray max array size is 2048 but was given " + value.length);
        }
    }

    public SyncableBoolArray(boolean[] value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        int r = value.length % 8;
        this.lenghth = value.length + (r == 0 ? 0 : 8 - r);
        this.bytes = new byte[this.lenghth / 8];
        this.lastTickBytes = new byte[this.lenghth / 8];
        this.boolCache = new boolean[this.lenghth];
        if (value.length > 2048) {
            throw new IllegalArgumentException("BrandonsCore, SyncableBoolArray max array size is 2048 but was given " + value.length);
        }
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == this.lastTickBytes[i] && !forceSync) continue;
            this.lastTickBytes[i] = this.bytes[i];
            tile.dirtyBlock();
            if (player == null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.bytes[i], (byte)i, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.bytes[i], (byte)i, this.updateOnReceived), (EntityPlayerMP)player);
            }
            this.reCache();
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 12) {
            int index = packet.boolArrayPartIndex & 0xFF;
            if (index < 0 || index >= this.bytes.length) {
                return;
            }
            this.bytes[index] = packet.boolArrayPart;
            this.reCache();
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74773_a("SyncableBoolArray" + this.index, this.bytes);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        this.bytes = compound.func_74764_b("SyncableBoolArray" + this.index) ? compound.func_74770_j("SyncableBoolArray" + this.index) : new byte[this.lenghth];
        this.lastTickBytes = (byte[])this.bytes.clone();
        this.reCache();
    }

    public boolean get(int index) {
        if (index >= this.lenghth) {
            throw new IndexOutOfBoundsException("Index: " + index + " Array Size: " + this.lenghth);
        }
        return this.boolCache[index];
    }

    public void set(boolean b, int index) {
        try {
            if (index >= this.lenghth) {
                throw new IndexOutOfBoundsException("Index: " + index + " Array Size: " + this.lenghth);
            }
            this.boolCache[index] = b;
            String bs = Integer.toBinaryString(Byte.toUnsignedInt(this.bytes[index / 8]));
            while (bs.length() < 8) {
                bs = "0" + bs;
            }
            char[] bits = bs.toCharArray();
            bits[index % 8] = b ? 49 : 48;
            this.bytes[index / 8] = (byte)Integer.parseInt(new String(bits), 2);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void reCache() {
        try {
            for (int i = 0; i < this.lenghth; ++i) {
                String bits = Integer.toBinaryString(Byte.toUnsignedInt(this.bytes[i / 8]));
                while (bits.length() < 8) {
                    bits = "0" + bits;
                }
                this.boolCache[i] = bits.charAt(i % 8) == '1';
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int lenghth() {
        return this.lenghth;
    }

    public String toString() {
        return String.valueOf(this.boolCache);
    }
}

