/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlayerSlot {
    private int slot;
    private EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public String toString() {
        return this.category.getIndex() + ":" + this.slot;
    }

    public static PlayerSlot fromString(String slot) {
        try {
            return new PlayerSlot(Integer.parseInt(slot.substring(slot.indexOf(":") + 1)), EnumInvCategory.fromIndex(Integer.parseInt(slot.substring(0, slot.indexOf(":")))));
        }
        catch (Exception e) {
            LogHelperBC.error("Error loading slot reference from string! - " + slot);
            LogHelperBC.error("Required format \"inventory:slot\" Where inventory ether 0 (main), 1 (Armor) or 2 (Off Hand) and slot is the index in that inventory.");
            e.printStackTrace();
            return new PlayerSlot(0, EnumInvCategory.MAIN);
        }
    }

    public void setStackInSlot(EntityPlayer player, ItemStack stack) {
        if (this.category == EnumInvCategory.ARMOR) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70460_b.length) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_70460_b[this.slot] = stack;
        } else if (this.category == EnumInvCategory.MAIN) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70462_a.length) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_70462_a[this.slot] = stack;
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_184439_c.length) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_184439_c[this.slot] = stack;
        }
    }

    public ItemStack getStackInSlot(EntityPlayer player) {
        ItemStack[] stacks;
        if (this.category == EnumInvCategory.ARMOR) {
            stacks = player.field_71071_by.field_70460_b;
        } else if (this.category == EnumInvCategory.MAIN) {
            stacks = player.field_71071_by.field_70462_a;
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            stacks = player.field_71071_by.field_184439_c;
        } else {
            LogHelperBC.bigError("PlayerSlot#getStackInSlot Invalid or null category! This should not be possible! [%s]... Fix your Shit!", new Object[]{this.category});
            return null;
        }
        if (this.slot < 0 || this.slot >= stacks.length) {
            LogHelperBC.bigError("PlayerSlot#getStackInSlot Hay! I just saved you an index out of bounds! Be grateful and fix your shit!", new Object[0]);
            return null;
        }
        return stacks[this.slot];
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2);

        private int index;
        private static EnumInvCategory[] indexMap;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 2 || index < 0) {
                LogHelperBC.bigError("PlayerSlot.EnumInvCategory#fromIndex Attempt to read invalid index! [%s]", index);
                return indexMap[0];
            }
            return indexMap[index];
        }

        static {
            indexMap = new EnumInvCategory[3];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
        }
    }
}

