/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class ModuleManager {
    protected LinkedList<MGuiElementBase> elements = new LinkedList();
    protected LinkedList<MGuiElementBase> actionList = new LinkedList();
    private boolean requiresReSort = false;
    private IModularGui parentGui;
    private List<MGuiElementBase> toRemove = new ArrayList<MGuiElementBase>();
    private static Comparator<MGuiElementBase> renderSorter = new Comparator<MGuiElementBase>(){

        @Override
        public int compare(MGuiElementBase o1, MGuiElementBase o2) {
            return o1.displayLevel < o2.displayLevel ? -1 : (o1.displayLevel > o2.displayLevel ? 1 : 0);
        }
    };
    private static Comparator<MGuiElementBase> actionSorter = new Comparator<MGuiElementBase>(){

        @Override
        public int compare(MGuiElementBase o1, MGuiElementBase o2) {
            return o1.displayLevel < o2.displayLevel ? 1 : (o1.displayLevel > o2.displayLevel ? -1 : 0);
        }
    };

    public ModuleManager(IModularGui parentGui) {
        this.parentGui = parentGui;
    }

    public void initElements() {
        for (MGuiElementBase element : this.elements) {
            element.initElement();
        }
    }

    public MGuiElementBase add(MGuiElementBase element, int displayLevel) {
        if (displayLevel > 4) {
            LogHelperBC.error("ModularGui Display Level Out Of Bounds! Max is 4, someone is using " + displayLevel);
        }
        if (element.mc == null || element.fontRenderer == null) {
            element.setWorldAndResolution(this.parentGui.getMinecraft(), this.parentGui.screenWidth(), this.parentGui.screenHeight());
        }
        element.displayLevel = displayLevel;
        this.elements.add(element);
        this.requiresReSort = true;
        return element;
    }

    public MGuiElementBase add(MGuiElementBase element) {
        return this.add(element, 0);
    }

    public void remove(MGuiElementBase element) {
        if (this.elements.contains(element)) {
            this.toRemove.add(element);
            this.requiresReSort = true;
        }
    }

    public void removeByID(String id) {
        for (MGuiElementBase element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
            return;
        }
    }

    public void removeByGroup(String group) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
        }
    }

    public void setIDEnabled(String id, boolean enabled) {
        for (MGuiElementBase element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.setEnabled(enabled);
            return;
        }
    }

    public void setGroupEnabled(String group, boolean enabled) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isInGroup(group)) continue;
            element.setEnabled(enabled);
        }
    }

    public List<MGuiElementBase> getElements() {
        return this.elements;
    }

    public void clear() {
        this.elements.clear();
        this.requiresReSort = true;
    }

    protected boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int clickedDisplay = -100;
        for (MGuiElementBase element : this.actionList) {
            if (element.isEnabled() && clickedDisplay > -100 && element.displayLevel < clickedDisplay) {
                return true;
            }
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                clickedDisplay = element.displayLevel;
            }
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    protected boolean mouseReleased(int mouseX, int mouseY, int state) {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, state)) continue;
            return true;
        }
        return false;
    }

    protected boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        return false;
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseInput() throws IOException {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.handleMouseInput()) continue;
            return true;
        }
        return false;
    }

    public void renderBackgroundLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled()) continue;
            this.parentGui.setZLevel(element.displayLevel * 200);
            element.renderBackgroundLayer(mc, mouseX, mouseY, partialTicks);
        }
    }

    public void renderForegroundLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled()) continue;
            this.parentGui.setZLevel(element.displayLevel * 200);
            element.renderForegroundLayer(mc, mouseX, mouseY, partialTicks);
        }
    }

    public boolean renderOverlayLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int renderDisplay = -100;
        for (MGuiElementBase element : this.actionList) {
            if (element.isEnabled() && renderDisplay > -100 && element.displayLevel < renderDisplay) {
                return true;
            }
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                renderDisplay = element.displayLevel;
            }
            if (!element.isEnabled() || !element.renderOverlayLayer(mc, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public boolean isAreaUnderElement(int posX, int posY, int xSize, int ySize, int zLevel) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled() || element.displayLevel * 200 < zLevel || !element.getRectangle().intersects(posX, posY, xSize, ySize)) continue;
            return true;
        }
        return false;
    }

    public void onUpdate() {
        MGuiElementBase element;
        if (!this.toRemove.isEmpty()) {
            this.elements.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext() && !(element = (MGuiElementBase)iterator.next()).onUpdate()) {
        }
        if (this.requiresReSort) {
            this.sort();
        }
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        for (MGuiElementBase element : this.elements) {
            element.setWorldAndResolution(mc, width, height);
        }
        this.initElements();
    }

    private void sort() {
        Collections.sort(this.elements, renderSorter);
        this.actionList.clear();
        this.actionList.addAll(this.elements);
        Collections.sort(this.actionList, actionSorter);
    }
}

