/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.shifter;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.api.pipes.IShifter;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.blocks.TileBase;
import pl.asie.charset.lib.inventory.InventoryUtils;
import pl.asie.charset.lib.utils.FluidUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RedstoneUtils;
import pl.asie.charset.pipes.ModCharsetPipes;
import pl.asie.charset.pipes.PipeUtils;
import pl.asie.charset.pipes.pipe.PartPipe;
import pl.asie.charset.pipes.pipe.PipeFluidContainer;

public class TileShifter
extends TileBase
implements IShifter,
ITickable {
    private ItemStack[] filters = new ItemStack[6];
    private int redstoneLevel;
    private int ticker = ModCharsetPipes.RANDOM.nextInt(256);

    public EnumFacing getDirection(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)Properties.FACING);
    }

    @Override
    public EnumFacing getDirection() {
        if (this.field_145850_b != null) {
            return this.getDirection(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        return EnumFacing.UP;
    }

    private boolean isInput(TileEntity input, EnumFacing direction) {
        if (input != null) {
            if (InventoryUtils.getItemHandler(input, direction) != null) {
                return true;
            }
            IFluidHandler fluidHandler = FluidUtils.getFluidHandler(input, direction);
            if (fluidHandler != null) {
                return !(fluidHandler instanceof PipeFluidContainer.Tank);
            }
        }
        return false;
    }

    @Override
    public IShifter.Mode getMode() {
        EnumFacing direction = this.getDirection();
        TileEntity input = this.getNeighbourTile(direction.func_176734_d());
        return this.isInput(input, direction) ? IShifter.Mode.Extract : IShifter.Mode.Shift;
    }

    public ItemStack[] getFilters() {
        return this.filters;
    }

    public void setFilter(int side, ItemStack stack) {
        this.filters[side] = stack;
        this.markBlockForUpdate();
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    @Override
    public boolean initialize() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.updateRedstoneLevel();
            return true;
        }
        return false;
    }

    @Override
    public int getShiftDistance() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isShifting() {
        return this.getRedstoneLevel() > 0;
    }

    @Override
    public boolean hasFilter() {
        for (ItemStack s : this.filters) {
            if (s == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ItemStack source) {
        int filterCount = 0;
        boolean matches = false;
        for (int i = 0; i < 6; ++i) {
            if (this.filters[i] == null) continue;
            ++filterCount;
            if (!ItemUtils.equals(source, this.filters[i], false, this.filters[i].func_77981_g(), false)) continue;
            matches = true;
            break;
        }
        return filterCount == 0 || matches;
    }

    @Override
    public boolean matches(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (!this.hasFilter()) {
            return true;
        }
        for (ItemStack s : this.filters) {
            FluidStack filter;
            if (s == null) continue;
            if (FluidContainerRegistry.containsFluid((ItemStack)s, (FluidStack)stack)) {
                return true;
            }
            if (!(s.func_77973_b() instanceof IFluidContainerItem) || (filter = ((IFluidContainerItem)s.func_77973_b()).getFluid(s)) == null || filter.amount <= 0 || !filter.isFluidEqual(stack)) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.ticker;
        if (this.redstoneLevel > 0) {
            EnumFacing direction = this.getDirection();
            TileEntity input = this.getNeighbourTile(direction.func_176734_d());
            PartPipe output = PipeUtils.getPipe(this.func_145831_w(), this.func_174877_v().func_177972_a(direction), direction.func_176734_d());
            if (input != null && output != null && output.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) {
                IItemHandler handler;
                FluidStack stack;
                IFluidHandler inTank = FluidUtils.getFluidHandler(input, direction);
                if (inTank != null && (stack = inTank.drain(80, false)) != null && this.matches(stack)) {
                    FluidUtils.push(inTank, (IFluidHandler)output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()), stack);
                }
                if (this.ticker % 16 == 0 && (handler = InventoryUtils.getItemHandler(input, direction)) != null) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        int maxSize;
                        ItemStack stack2;
                        ItemStack source = handler.getStackInSlot(i);
                        if (source == null || !this.matches(source) || (stack2 = handler.extractItem(i, maxSize = 1, true)) == null || output.injectItem(stack2, direction.func_176734_d(), true) != stack2.field_77994_a) continue;
                        stack2 = handler.extractItem(i, maxSize, false);
                        if (stack2 != null) {
                            output.injectItem(stack2, direction.func_176734_d(), false);
                        }
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        this.redstoneLevel = nbt.func_74771_c("rs");
        NBTTagList filterList = nbt.func_150295_c("filters", 10);
        for (int i = 0; i < Math.min(filterList.func_74745_c(), this.filters.length); ++i) {
            NBTTagCompound cpd = filterList.func_150305_b(i);
            this.filters[i] = ItemStack.func_77949_a((NBTTagCompound)cpd);
        }
        if (isClient) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        nbt.func_74774_a("rs", (byte)this.redstoneLevel);
        NBTTagList filterList = new NBTTagList();
        for (int i = 0; i < this.filters.length; ++i) {
            NBTTagCompound fnbt = new NBTTagCompound();
            if (this.filters[i] != null) {
                this.filters[i].func_77955_b(fnbt);
            }
            filterList.func_74742_a((NBTBase)fnbt);
        }
        nbt.func_74782_a("filters", (NBTBase)filterList);
        return nbt;
    }

    public void updateRedstoneLevel() {
        int oldRedstoneLevel = this.redstoneLevel;
        this.redstoneLevel = 0;
        for (EnumFacing d : EnumFacing.field_82609_l) {
            this.redstoneLevel = Math.max(this.redstoneLevel, RedstoneUtils.getRedstonePowerWithWire(this.field_145850_b, this.field_174879_c.func_177972_a(d), d));
        }
        if (oldRedstoneLevel != this.redstoneLevel) {
            this.markBlockForUpdate();
            this.field_145850_b.func_180496_d(this.field_174879_c, this.func_145838_q());
        }
        EnumFacing direction = this.getDirection();
        PartPipe output = PipeUtils.getPipe(this.func_145831_w(), this.func_174877_v().func_177972_a(direction), direction.func_176734_d());
        if (output != null && (this.getMode() == IShifter.Mode.Extract && !output.connects(direction.func_176734_d()) || this.getMode() == IShifter.Mode.Shift && output.connects(direction.func_176734_d()))) {
            this.field_145850_b.func_180496_d(this.field_174879_c.func_177972_a(this.getDirection()), this.func_145838_q());
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return (facing == null || facing == this.getDirection()) && capability == ModCharsetPipes.CAP_SHIFTER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((facing == null || facing == this.getDirection()) && capability == ModCharsetPipes.CAP_SHIFTER) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

