/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.Iterator;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public final class MultipartUtils {
    private MultipartUtils() {
    }

    public static boolean hasCapability(Capability cap, World world, BlockPos pos, PartSlot slot, EnumFacing side) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container == null) {
            TileEntity tile = world.func_175625_s(pos);
            return tile != null ? tile.hasCapability(cap, side) : false;
        }
        return container.hasCapability(cap, slot, side);
    }

    public static <T> T getCapability(Capability<T> cap, World world, BlockPos pos, PartSlot slot, EnumFacing side) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container == null) {
            TileEntity tile = world.func_175625_s(pos);
            return (T)(tile != null ? tile.getCapability(cap, side) : null);
        }
        return (T)container.getCapability(cap, slot, side);
    }

    public static <T> T getInterface(Class<T> clazz, World world, BlockPos pos, EnumFacing side) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container == null) {
            TileEntity tile = world.func_175625_s(pos);
            return (T)(tile != null && clazz.isAssignableFrom(tile.getClass()) ? tile : null);
        }
        if (side == null) {
            return MultipartUtils.getInterfaceCenter(clazz, container);
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            T tmp;
            if (face == side || face == side.func_176734_d() || (tmp = MultipartUtils.getInterface(clazz, container, side, face)) == null) continue;
            return tmp;
        }
        return null;
    }

    public static <T> T getInterfaceCenter(Class<T> clazz, IMultipartContainer container) {
        IMultipart p;
        ISlottedPart part = container.getPartInSlot(PartSlot.CENTER);
        if (part != null && clazz.isAssignableFrom(part.getClass())) {
            return (T)part;
        }
        Iterator var4 = container.getParts().iterator();
        do {
            if (var4.hasNext()) continue;
            return null;
        } while ((p = (IMultipart)var4.next()) instanceof ISlottedPart && !((ISlottedPart)p).getSlotMask().isEmpty() || p == null || !clazz.isAssignableFrom(p.getClass()));
        return (T)p;
    }

    public static <T> T getInterface(Class<T> clazz, IMultipartContainer container, EnumFacing side, EnumFacing face) {
        if (container == null) {
            return null;
        }
        if (side == null) {
            return MultipartUtils.getInterfaceCenter(clazz, container);
        }
        if (face == side.func_176734_d()) {
            return null;
        }
        ISlottedPart part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side));
        if (part != null) {
            return (T)(clazz.isAssignableFrom(part.getClass()) ? part : null);
        }
        if (side != face && face != null) {
            part = container.getPartInSlot(PartSlot.getEdgeSlot((EnumFacing)side, (EnumFacing)face));
            if (part != null) {
                return (T)(clazz.isAssignableFrom(part.getClass()) ? part : null);
            }
            part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)face));
            if (part != null) {
                return (T)(clazz.isAssignableFrom(part.getClass()) ? part : null);
            }
            return MultipartUtils.getInterfaceCenter(clazz, container);
        }
        return MultipartUtils.getInterfaceCenter(clazz, container);
    }

    public static <T> T getInterface(Class<T> clazz, World world, BlockPos pos, EnumFacing side, EnumFacing face) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container == null) {
            TileEntity tile = world.func_175625_s(pos);
            return (T)(tile != null && clazz.isAssignableFrom(tile.getClass()) ? tile : null);
        }
        if (side == null) {
            return MultipartUtils.getInterfaceCenter(clazz, container);
        }
        return MultipartUtils.getInterface(clazz, container, side, face);
    }
}

