/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public final class CapabilityUtils {
    private CapabilityUtils() {
    }

    public static boolean hasCapability(World world, BlockPos pos, Capability<?> capability, EnumFacing facing, boolean tiles, boolean entities) {
        TileEntity tile;
        if (tiles && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(capability, facing)) {
            return true;
        }
        if (entities) {
            List entityList = world.func_72839_b(null, new AxisAlignedBB(pos));
            for (Entity entity : entityList) {
                if (!entity.hasCapability(capability, facing)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T getCapability(World world, BlockPos pos, Capability<T> capability, EnumFacing facing, boolean tiles, boolean entities) {
        TileEntity tile;
        if (tiles && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(capability, facing)) {
            return (T)tile.getCapability(capability, facing);
        }
        if (entities) {
            List entityList = world.func_72839_b(null, new AxisAlignedBB(pos));
            for (Entity entity : entityList) {
                if (!entity.hasCapability(capability, facing)) continue;
                return (T)entity.getCapability(capability, facing);
            }
        }
        return null;
    }
}

