/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.render.BaseBakedModel;
import pl.asie.charset.lib.render.IRenderComparable;
import pl.asie.charset.lib.render.ModelKey;

public abstract class ModelFactory<T extends IRenderComparable<T>>
extends BaseBakedModel {
    private static final boolean DISABLE_CACHE = false;
    private static final Set<ModelFactory> FACTORIES = new HashSet<ModelFactory>();
    private final Cache<ModelKey<T>, IBakedModel> cache;
    private final IUnlistedProperty<T> property;

    protected ModelFactory(IUnlistedProperty<T> property, ResourceLocation particle) {
        super(particle);
        FACTORIES.add(this);
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        this.property = property;
    }

    public static void clearCaches() {
        for (ModelFactory factory : FACTORIES) {
            factory.cache.invalidateAll();
        }
    }

    public IUnlistedProperty<T> getProperty() {
        return this.property;
    }

    public abstract IBakedModel bake(T var1, boolean var2, BlockRenderLayer var3);

    public abstract T fromItemStack(ItemStack var1);

    public IBakedModel getModel(T object, BlockRenderLayer layer) {
        if (object == null) {
            return null;
        }
        ModelKey<T> key = new ModelKey<T>(object, layer);
        IBakedModel model = (IBakedModel)this.cache.getIfPresent(key);
        if (model != null) {
            return model;
        }
        model = this.bake(object, layer == null, layer);
        this.cache.put(key, (Object)model);
        return model;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IBakedModel model;
        if (state instanceof IExtendedBlockState && (model = this.getModel((IRenderComparable)((IExtendedBlockState)state).getValue(this.property), MinecraftForgeClient.getRenderLayer())) != null) {
            return model.func_188616_a(state, side, rand);
        }
        return ImmutableList.of();
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150364_r.func_176223_P());
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return MFItemOverride.INSTANCE;
    }

    private static class MFItemOverride
    extends ItemOverrideList {
        public static final MFItemOverride INSTANCE = new MFItemOverride();

        private MFItemOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (originalModel instanceof ModelFactory) {
                ModelFactory factory = (ModelFactory)originalModel;
                Object o = factory.fromItemStack(stack);
                return factory.getModel(o, null);
            }
            return originalModel;
        }
    }
}

