/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.refinedstorage.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.refinedstorage.Solderer")
public class Solderer {
    @ZenMethod
    public static void add(IItemStack output, int time, IItemStack row2) {
        Solderer.add(output, time, null, row2, null);
    }

    @ZenMethod
    public static void add(IItemStack output, int time, IItemStack row1, IItemStack row2, @Optional IItemStack row3) {
        MineTweakerAPI.apply((IUndoableAction)new Add(Solderer.createISoldererRecipe(InputHelper.toStack((IItemStack)output), time, InputHelper.toStack((IItemStack)row1), InputHelper.toStack((IItemStack)row2), InputHelper.toStack((IItemStack)row3))));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(new SoldererRemovalRecipe(InputHelper.toStack((IItemStack)output))));
    }

    private static ISoldererRecipe createISoldererRecipe(ItemStack output, int time, ItemStack ... rows) {
        return API.instance().getSoldererRegistry().createSimpleRecipe(output, time, rows);
    }

    private static class SoldererRemovalRecipe
    implements ISoldererRecipe {
        private ItemStack output;

        protected SoldererRemovalRecipe(ItemStack output) {
            this.output = output;
        }

        @Nullable
        public ItemStack getRow(int i) {
            return null;
        }

        @Nonnull
        public ItemStack getResult() {
            return this.output;
        }

        public int getDuration() {
            return 0;
        }
    }

    private static class Remove
    extends BaseListRemoval<ISoldererRecipe> {
        protected Remove(ISoldererRecipe recipe) {
            super("Solderer", API.instance().getSoldererRegistry().getRecipes());
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (ISoldererRecipe recipe : this.recipes) {
                if (recipe != null) {
                    List removed = API.instance().getSoldererRegistry().removeRecipe(recipe.getResult(), new ItemStack[0]);
                    if (removed.size() > 0) {
                        this.successful.addAll(removed);
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(ISoldererRecipe recipe) {
            return "SoldererRemovalRecipe:" + LogHelper.getStackDescription((Object)recipe.getResult());
        }
    }

    private static class Add
    extends BaseListAddition<ISoldererRecipe> {
        protected Add(ISoldererRecipe recipe) {
            super("Solderer", API.instance().getSoldererRegistry().getRecipes());
            this.recipes.add(recipe);
        }

        protected String getRecipeInfo(ISoldererRecipe recipe) {
            StringBuilder build = new StringBuilder();
            build.append("ISoldererRecipe");
            build.append(LogHelper.getStackDescription((Object)recipe.getResult())).append("; ");
            build.append("duration:").append(recipe.getDuration()).append("; ");
            for (int i = 0; i < 3; ++i) {
                build.append(LogHelper.getStackDescription((Object)recipe.getRow(i))).append(", ");
            }
            build.setLength(build.length() - 2);
            return build.toString();
        }

        public void undo() {
            for (ISoldererRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (API.instance().getSoldererRegistry().removeRecipe(recipe.getResult(), new ItemStack[]{recipe.getRow(0), recipe.getRow(1), recipe.getRow(2)}).size() > 0) continue;
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }
    }
}

