/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingManager;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.FabricatorRecipe;
import modtweaker.mods.forestry.recipes.FabricatorSmeltingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.ThermionicFabricator")
public class ThermionicFabricator {
    public static final String nameSmelting = "Forestry Thermionic Fabricator (Smelting)";
    public static final String nameCasting = "Forestry Thermionic Fabricator (Casting)";

    @ZenMethod
    public static void addSmelting(int fluidOutput, IItemStack itemInput, int meltingPoint) {
        MineTweakerAPI.apply((IUndoableAction)new AddSmelting(new FabricatorSmeltingRecipe(InputHelper.toStack((IItemStack)itemInput), FluidRegistry.getFluidStack((String)"glass", (int)fluidOutput), meltingPoint)));
    }

    @ZenMethod
    public static void addCast(IItemStack output, IIngredient[][] ingredients, int fluidInput, @Optional IItemStack plan) {
        ShapedRecipeCustom recipe = new ShapedRecipeCustom(InputHelper.toStack((IItemStack)output), InputHelper.toShapedObjects((IIngredient[][])ingredients));
        MineTweakerAPI.apply((IUndoableAction)new AddCast(new FabricatorRecipe(InputHelper.toStack((IItemStack)plan), FluidRegistry.getFluidStack((String)"glass", (int)fluidInput), (IDescriptiveRecipe)recipe)));
    }

    @ZenMethod
    public static void removeSmelting(IIngredient itemInput) {
        LinkedList<IFabricatorSmeltingRecipe> recipes = new LinkedList<IFabricatorSmeltingRecipe>();
        for (IFabricatorSmeltingRecipe r : RecipeManagers.fabricatorSmeltingManager.recipes()) {
            if (r == null || r.getResource() == null || !StackHelper.matches((IIngredient)itemInput, (IItemStack)InputHelper.toIItemStack((ItemStack)r.getResource()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveSmelting(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, itemInput.toString()));
        }
    }

    @ZenMethod
    public static void removeCast(IIngredient product) {
        LinkedList<IFabricatorRecipe> recipes = new LinkedList<IFabricatorRecipe>();
        for (IFabricatorRecipe r : RecipeManagers.fabricatorManager.recipes()) {
            if (r == null || r.getRecipeOutput() == null || !StackHelper.matches((IIngredient)product, (IItemStack)InputHelper.toIItemStack((ItemStack)r.getRecipeOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveCasts(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, product.toString()));
        }
    }

    private static class RemoveCasts
    extends ForestryListRemoval<IFabricatorRecipe, IFabricatorManager> {
        public RemoveCasts(List<IFabricatorRecipe> recipes) {
            super(ThermionicFabricator.nameCasting, RecipeManagers.fabricatorManager, recipes);
        }

        @Override
        public String getRecipeInfo(IFabricatorRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput());
        }

        public IRecipeWrapper wrapRecipe(IFabricatorRecipe recipe) {
            return new FabricatorRecipeWrapper(recipe);
        }
    }

    private static class RemoveSmelting
    extends ForestryListRemoval<IFabricatorSmeltingRecipe, IFabricatorSmeltingManager> {
        public RemoveSmelting(List<IFabricatorSmeltingRecipe> recipes) {
            super(ThermionicFabricator.nameSmelting, RecipeManagers.fabricatorSmeltingManager, recipes);
        }

        @Override
        public String getRecipeInfo(IFabricatorSmeltingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResource());
        }

        public IRecipeWrapper wrapRecipe(IFabricatorSmeltingRecipe recipe) {
            return null;
        }
    }

    private static class AddCast
    extends ForestryListAddition<IFabricatorRecipe> {
        public AddCast(IFabricatorRecipe recipe) {
            super(ThermionicFabricator.nameCasting, (ICraftingProvider)RecipeManagers.fabricatorManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFabricatorRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput());
        }

        public IRecipeWrapper wrapRecipe(IFabricatorRecipe recipe) {
            return new FabricatorRecipeWrapper(recipe);
        }
    }

    private static class AddSmelting
    extends ForestryListAddition<IFabricatorSmeltingRecipe> {
        public AddSmelting(IFabricatorSmeltingRecipe recipe) {
            super(ThermionicFabricator.nameSmelting, (ICraftingProvider)RecipeManagers.fabricatorSmeltingManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFabricatorSmeltingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResource());
        }

        public IRecipeWrapper wrapRecipe(IFabricatorSmeltingRecipe recipe) {
            return null;
        }
    }
}

