/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListRemoval;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.MineTweakerAPI;

public abstract class ForestryListRemoval<T extends IForestryRecipe, C extends ICraftingProvider<T>>
extends BaseListRemoval<T> {
    private final C craftingProvider;

    public ForestryListRemoval(String name, C craftingProvider, List<T> recipes) {
        super(name, new ArrayList(craftingProvider.recipes()), recipes);
        this.craftingProvider = craftingProvider;
    }

    protected abstract String getRecipeInfo(T var1);

    public void apply() {
        for (IForestryRecipe recipe : this.recipes) {
            if (recipe != null) {
                if (this.craftingProvider.removeRecipe(recipe)) {
                    this.successful.add(recipe);
                    IRecipeWrapper wrapped = this.wrapRecipe(recipe);
                    if (wrapped == null) continue;
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)wrapped);
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                continue;
            }
            LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    public final void undo() {
        for (IForestryRecipe recipe : this.successful) {
            if (recipe != null) {
                if (!this.craftingProvider.addRecipe(recipe)) {
                    LogHelper.logError((String)String.format("Error restoring %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                    continue;
                }
                IRecipeWrapper wrapped = this.wrapRecipe(recipe);
                if (wrapped == null) continue;
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)wrapped);
                continue;
            }
            LogHelper.logError((String)String.format("Error restoring %s Recipe: null object", this.name));
        }
    }
}

