/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class NBTHelper {
    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        return NBTHelper.getOrInitTagCompound(player.getEntityData(), "PlayerPersisted", null);
    }

    public static NBTTagCompound getOrCreatePersistentTag(EntityPlayer player) {
        return NBTHelper.getOrInitTagCompound(player.getEntityData(), "PlayerPersisted", new NBTTagCompound());
    }

    public static NBTTagCompound getOrInitTagCompound(NBTTagCompound parent, String key) {
        return NBTHelper.getOrInitTagCompound(parent, key, null);
    }

    public static NBTTagCompound getOrInitTagCompound(NBTTagCompound parent, String key, NBTTagCompound defaultTag) {
        if (parent.func_150297_b(key, 10)) {
            return parent.func_74775_l(key);
        }
        defaultTag = defaultTag == null ? new NBTTagCompound() : defaultTag.func_74737_b();
        parent.func_74782_a(key, (NBTBase)defaultTag);
        return defaultTag;
    }

    public static NBTTagCompound proifleToNBT(GameProfile profile) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static GameProfile profileFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        UUID uuid = null;
        if (tag.func_74764_b("UUIDL")) {
            uuid = new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
        } else if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static Iterable<NBTTagCompound> iterateNBTTagList(final NBTTagList list) {
        return new Iterable<NBTTagCompound>(){

            @Override
            public Iterator<NBTTagCompound> iterator() {
                return new Iterator<NBTTagCompound>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < list.func_74745_c();
                    }

                    @Override
                    public NBTTagCompound next() {
                        return list.func_150305_b(this.i++);
                    }

                    @Override
                    public void remove() {
                        list.func_74744_a(this.i--);
                    }
                };
            }
        };
    }

    public static NBTTagCompound getOrInitTagCompound(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            return tags;
        }
        tags = new NBTTagCompound();
        stack.func_77982_d(tags);
        return tags;
    }

    public static boolean hasPersistantNBT(Entity entity) {
        return entity.getEntityData().func_150297_b("PlayerPersisted", 10);
    }

    public static NBTTagCompound getPersistantNBT(Entity entity) {
        NBTTagCompound t = entity.getEntityData();
        return NBTHelper.getOrInitTagCompound(t, "PlayerPersisted");
    }

    public static NBTTagCompound blockPosToNBT(BlockPos pos) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74774_a("y", (byte)pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        return nbt;
    }

    public static BlockPos nbtToBlockPos(NBTTagCompound nbt) {
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74771_c("y") & 0xFF;
        int z = nbt.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static <T extends NBTBase> void deserializeSubTag(INBTSerializable<T> serializable, NBTTagCompound parent, String key) {
        NBTBase tag = parent.func_74781_a(key);
        if (tag != null) {
            serializable.deserializeNBT(tag);
        }
    }

    public static List<String> getFluidStackRecipeEntry(NBTBase base) {
        switch (base.func_74732_a()) {
            case 8: {
                return ImmutableList.of((Object)((NBTTagString)base).func_150285_a_());
            }
            case 10: {
                return ImmutableList.of((Object)FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)base)).getFluid().getName());
            }
            case 9: {
                ArrayList<String> objects = new ArrayList<String>();
                NBTTagList list = (NBTTagList)base;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTBase nbtBase = list.func_179238_g(i);
                    objects.addAll(NBTHelper.getFluidStackRecipeEntry(nbtBase));
                }
                return objects;
            }
        }
        throw new IllegalArgumentException("Unable to process fluidstack tag, " + base);
    }

    public static List<ItemStack> getItemStackRecipeEntry(NBTBase base) {
        switch (base.func_74732_a()) {
            case 8: {
                return OreDictionary.getOres((String)((NBTTagString)base).func_150285_a_());
            }
            case 10: {
                return ImmutableList.of((Object)StackHelper.loadFromNBT((NBTTagCompound)base));
            }
            case 9: {
                ArrayList<ItemStack> objects = new ArrayList<ItemStack>();
                NBTTagList list = (NBTTagList)base;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTBase nbtBase = list.func_179238_g(i);
                    objects.addAll(NBTHelper.getItemStackRecipeEntry(nbtBase));
                }
                return objects;
            }
        }
        throw new IllegalArgumentException("Unable to process itemstack/ore tag, " + base);
    }

    @Nullable
    public static String getStringOrNull(NBTTagCompound nbt, String key) {
        return nbt.func_74764_b("background_texture") ? nbt.func_74779_i(key) : null;
    }

    public static <T, N extends NBTBase> NBTTagList createList(Collection<T> list, Function<T, N> convertor) {
        NBTTagList nbtTagList = new NBTTagList();
        for (T t : list) {
            NBTBase tag = (NBTBase)convertor.apply(t);
            nbtTagList.func_74742_a(tag);
        }
        return nbtTagList;
    }

    public static <T extends INBTSerializable<N>, N extends NBTBase> List<T> processList(NBTTagList list, Supplier<T> blankSupplier) {
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            INBTSerializable newInstance = (INBTSerializable)blankSupplier.get();
            newInstance.deserializeNBT(list.func_179238_g(i));
            objects.add(newInstance);
        }
        return objects;
    }

    public static <T, N extends NBTBase> List<T> processList(NBTTagList list, Function<N, T> convertor) {
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            objects.add(convertor.apply(list.func_179238_g(i)));
        }
        return objects;
    }

    public static NBTTagList getTagListAnyType(NBTTagCompound tag, String key) {
        NBTBase base = NullHelper.nullable(tag.func_74781_a(key));
        if (base == null || base.func_74732_a() != 9) {
            return new NBTTagList();
        }
        return (NBTTagList)base;
    }
}

