/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat.tcon;

import com.rwtema.extrautils2.fluids.TexturePlasma;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

class XUTConTexturePalette
extends AbstractColoredTexture {
    int min;
    int max;
    private int[] colorPalette;

    public XUTConTexturePalette(TextureAtlasSprite baseTexture, String location, int[] palette) {
        super(baseTexture, location);
        this.colorPalette = palette;
        this.min = 255;
        this.max = 0;
    }

    protected void processData(int[][] data) {
        this.min = 255;
        this.max = 0;
        for (int c : data[0]) {
            if (TexturePlasma.directColorModel.getAlpha(c) < 32) continue;
            int brightness = XUTConTexturePalette.getBrightness(c);
            this.min = Math.min(this.min, brightness);
            this.max = Math.max(this.max, brightness);
        }
        super.processData(data);
    }

    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        if (pixel == 0 || TexturePlasma.directColorModel.getAlpha(pixel) < 32) {
            return 0;
        }
        int brightness = XUTConTexturePalette.getBrightness(pixel);
        float intensity = (float)(brightness - this.min) / (float)(this.max - this.min);
        return TexturePlasma.interpolate(intensity, this.colorPalette);
    }

    public static int getBrightness(int pixel) {
        return ColorHelper.brightness(TexturePlasma.directColorModel.getRed(pixel), TexturePlasma.directColorModel.getGreen(pixel), TexturePlasma.directColorModel.getBlue(pixel));
    }
}

