/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BoxQuadList
extends Box {
    Map<EnumFacing, List<BakedQuad>> sidedQuads = new HashMap<EnumFacing, List<BakedQuad>>();

    public BoxQuadList(Map<EnumFacing, List<BakedQuad>> sidedQuads) {
        super(BoxQuadList.getFullBounds(Iterables.concat(sidedQuads.values())));
        this.sidedQuads = sidedQuads;
        for (EnumFacing facing : FacingHelper.facingPlusNull) {
            sidedQuads.computeIfAbsent(facing, t -> ImmutableList.of());
        }
    }

    public BoxQuadList(Iterable<BakedQuad> quads) {
        super(BoxQuadList.getFullBounds(quads));
        HashMap<EnumFacing, ImmutableList.Builder> builderHashMap = new HashMap<EnumFacing, ImmutableList.Builder>();
        for (Object facing : FacingHelper.facingPlusNull) {
            builderHashMap.put((EnumFacing)facing, new ImmutableList.Builder());
        }
        for (BakedQuad quad : quads) {
            AxisAlignedBB bounds = BoxQuadList.getBounds(quad);
            Object side = bounds.field_72340_a == 1.0 && bounds.field_72336_d == 1.0 ? EnumFacing.EAST : (bounds.field_72340_a == 0.0 && bounds.field_72336_d == 0.0 ? EnumFacing.WEST : (bounds.field_72338_b == 1.0 && bounds.field_72337_e == 1.0 ? EnumFacing.UP : (bounds.field_72338_b == 0.0 && bounds.field_72337_e == 0.0 ? EnumFacing.DOWN : (bounds.field_72339_c == 1.0 && bounds.field_72334_f == 1.0 ? EnumFacing.SOUTH : (bounds.field_72339_c == 0.0 && bounds.field_72334_f == 0.0 ? EnumFacing.NORTH : null)))));
            ((ImmutableList.Builder)builderHashMap.get(side)).add((Object)quad);
        }
        for (Object facing : FacingHelper.facingPlusNull) {
            this.sidedQuads.put((EnumFacing)facing, (List<BakedQuad>)((ImmutableList.Builder)builderHashMap.get(facing)).build());
        }
    }

    public static Box getFullBounds(Iterable<BakedQuad> quads) {
        AxisAlignedBB bound = null;
        for (BakedQuad quad : quads) {
            if (bound == null) {
                bound = BoxQuadList.getBounds(quad);
                continue;
            }
            bound = bound.func_111270_a(BoxQuadList.getBounds(quad));
        }
        return new Box(bound);
    }

    public static AxisAlignedBB getBounds(BakedQuad quads) {
        int[] vertex = quads.func_178209_a();
        AxisAlignedBB bb = null;
        for (int i = 0; i < 4; ++i) {
            float x = Float.intBitsToFloat(vertex[i * 7]);
            float y = Float.intBitsToFloat(vertex[i * 7 + 1]);
            float z = Float.intBitsToFloat(vertex[i * 7 + 2]);
            AxisAlignedBB t = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
            bb = bb == null ? t : bb.func_111270_a(t);
        }
        return bb;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable EnumFacing side) {
        return this.sidedQuads.get(side);
    }
}

