/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.compatibility.ICompatPerspectiveAwareModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ModifyingBakedModel
implements IBakedModel {
    IBakedModel base;
    IQuadReDesigner designer;

    private ModifyingBakedModel(IBakedModel base, IQuadReDesigner designer) {
        this.base = base;
        this.designer = designer;
    }

    public static ModifyingBakedModel create(IBakedModel base, IQuadReDesigner designer) {
        if (base instanceof ICompatPerspectiveAwareModel) {
            return new ModifyingBakedModelPersp((ICompatPerspectiveAwareModel)base, designer);
        }
        return new ModifyingBakedModel(base, designer);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.designer.redesign(this.base.func_188616_a(state, side, rand), this.base, state, side, rand);
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.base.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.base.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.base.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        final ItemOverrideList overrides = this.base.func_188617_f();
        return new ItemOverrideList(Lists.newArrayList()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
                IBakedModel iBakedModel = overrides.handleItemState(originalModel, stack, world, entity);
                if (iBakedModel == ModifyingBakedModel.this.base) {
                    return ModifyingBakedModel.this;
                }
                return ModifyingBakedModel.create(iBakedModel, ModifyingBakedModel.this.designer);
            }
        };
    }

    private static class ModifyingBakedModelPersp
    extends ModifyingBakedModel
    implements ICompatPerspectiveAwareModel {
        private final ICompatPerspectiveAwareModel basePersp;

        private ModifyingBakedModelPersp(ICompatPerspectiveAwareModel base, IQuadReDesigner designer) {
            super((IBakedModel)base, designer);
            this.basePersp = base;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = this.basePersp.handlePerspective(cameraTransformType);
            IBakedModel model = (IBakedModel)pair.getLeft();
            ModifyingBakedModel m = model == this.basePersp ? this : ModifyingBakedModelPersp.create(model, this.designer);
            return Pair.of((Object)m, (Object)pair.getRight());
        }
    }

    public static interface IQuadReDesigner {
        @Nonnull
        public List<BakedQuad> redesign(@Nonnull List<BakedQuad> var1, IBakedModel var2, IBlockState var3, EnumFacing var4, long var5);
    }
}

