/*
 * Decompiled with CFR 0.152.
 */
package vazkii.blockdispenser;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="BlockDispenser", name="BlockDispenser", version="1.0", acceptedMinecraftVersions="[1.10]")
public class ModBlockDispenser {
    List<String> blacklist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        String[] blacklist = config.getStringList("blacklist", "general", new String[]{"minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava", "minecraft:fire", "minecraft:web"}, "");
        this.blacklist = Arrays.asList(blacklist);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (ResourceLocation r : Block.field_149771_c.func_148742_b()) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)r);
            Item item = Item.func_150898_a((Block)block);
            if (block == null || item == null || !(item instanceof ItemBlock) || this.blacklist.contains(r.toString()) || BlockDispenser.field_149943_a.func_148741_d((Object)item)) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)new BehaviourBlock((ItemBlock)item, block));
        }
    }

    public class BehaviourBlock
    extends BehaviorDefaultDispenseItem {
        ItemBlock item;
        Block block;

        public BehaviourBlock(ItemBlock item, Block block) {
            this.item = item;
            this.block = block;
        }

        public ItemStack func_82487_b(IBlockSource par1IBlockSource, ItemStack par2ItemStack) {
            EnumFacing facing = (EnumFacing)par1IBlockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            EnumFacing.Axis axis = facing.func_176740_k();
            BlockPos pos = par1IBlockSource.func_180699_d().func_177972_a(facing);
            World world = par1IBlockSource.func_82618_k();
            if (world.func_175623_d(pos) && this.block.func_176196_c(world, pos)) {
                int meta = this.item.func_77647_b(par2ItemStack.func_77952_i());
                IBlockState state = this.block.func_176203_a(meta);
                Collection props = state.func_177227_a();
                if (props.contains(BlockDirectional.field_176387_N)) {
                    state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing);
                } else if (props.contains(BlockHorizontal.field_185512_D) && axis != EnumFacing.Axis.Y) {
                    state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing);
                } else if (props.contains(BlockRotatedPillar.field_176298_M)) {
                    state = state.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)axis);
                }
                if (this.block instanceof BlockStairs) {
                    state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing.func_176734_d());
                }
                if (this.block instanceof BlockLog) {
                    state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.field_176299_a.func_185929_b(axis.func_176610_l()).or((Object)BlockLog.EnumAxis.NONE));
                }
                if (this.block instanceof BlockQuartz) {
                    BlockQuartz.EnumType type = (BlockQuartz.EnumType)state.func_177229_b((IProperty)BlockQuartz.field_176335_a);
                    if (ImmutableSet.of((Object)BlockQuartz.EnumType.LINES_X, (Object)BlockQuartz.EnumType.LINES_Y, (Object)BlockQuartz.EnumType.LINES_Z).contains((Object)type)) {
                        state = state.func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.field_176335_a.func_185929_b("lines_" + axis.func_176610_l()).or((Object)BlockQuartz.EnumType.LINES_Y));
                    }
                }
                world.func_175656_a(pos, state);
                SoundType soundtype = this.block.func_185467_w();
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                --par2ItemStack.field_77994_a;
                return par2ItemStack;
            }
            return super.func_82487_b(par1IBlockSource, par2ItemStack);
        }
    }
}

